/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.alfresco.repo.event.databind.ObjectMapperFactory;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.skyscreamer.jsonassert.Customization;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.ValueMatcher;
import org.skyscreamer.jsonassert.comparator.CustomComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public class TestUtil {
    public static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createInstance();
    public static final Pattern UUID_PATTERN = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}");
    public static final Pattern DATE_TIME_PATTERN = Pattern.compile("^([0-9]+)-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01])[Tt]([01][0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9]|60)(\\.[0-9]+)?(([Zz])|([+|\\-]([01][0-9]|2[0-3]):[0-5][0-9]))$");
    public static final ValueMatcher<Object> UUID_VALUE_MATCHER = (o1, o2) -> UUID_PATTERN.matcher(o1.toString()).matches() && UUID_PATTERN.matcher(o2.toString()).matches();
    public static final ValueMatcher<Object> DATE_TIME_VALUE_MATCHER = (o1, o2) -> DATE_TIME_PATTERN.matcher(o1.toString()).matches() && DATE_TIME_PATTERN.matcher(o2.toString()).matches();
    public static final ValueMatcher<Object> ELEMENTS_ORDERING_MATCHER = (o1, o2) -> {
        try {
            JSONAssert.assertEquals((String)o1.toString(), (String)o2.toString(), (JSONCompareMode)JSONCompareMode.LENIENT);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    };
    public static final Customization[] CUSTOMIZATIONS = new Customization[]{new Customization("id", UUID_VALUE_MATCHER), new Customization("data.eventGroupId", UUID_VALUE_MATCHER), new Customization("data.resource.id", UUID_VALUE_MATCHER), new Customization("data.resource.parent.id", UUID_VALUE_MATCHER), new Customization("data.resource.child.id", UUID_VALUE_MATCHER), new Customization("data.resource.source.id", UUID_VALUE_MATCHER), new Customization("data.resource.target.id", UUID_VALUE_MATCHER), new Customization("time", DATE_TIME_VALUE_MATCHER), new Customization("data.resource.createdAt", DATE_TIME_VALUE_MATCHER), new Customization("data.resource.modifiedAt", DATE_TIME_VALUE_MATCHER), new Customization("data.resourceBefore.modifiedAt", DATE_TIME_VALUE_MATCHER), new Customization("data.resource.aspectNames", ELEMENTS_ORDERING_MATCHER), new Customization("extensionAttributes.extObject.id", UUID_VALUE_MATCHER), new Customization("extensionAttributes.extObject.setProp", ELEMENTS_ORDERING_MATCHER), new Customization("extensionAttributes.extObject.mapProp", ELEMENTS_ORDERING_MATCHER), new Customization("data.resourceReaderAuthorities", ELEMENTS_ORDERING_MATCHER), new Customization("data.resourceDeniedAuthorities", ELEMENTS_ORDERING_MATCHER), new Customization("data.resourceReaderSecurityControls", ELEMENTS_ORDERING_MATCHER), new Customization("extensionAttributes.client.id", UUID_VALUE_MATCHER)};
    public static final CustomComparator JSON_COMPARATOR = new CustomComparator(JSONCompareMode.STRICT, CUSTOMIZATIONS);

    public static String getResourceFileAsString(String fileName) throws Exception {
        InputStream inputStream = TestUtil.class.getClassLoader().getResourceAsStream(fileName);
        if (inputStream == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static List<String> getTestNodePrimaryHierarchy() {
        return List.of("521aac1c-20eb-444b-a137-2da3d35ee1a8", "2641bbe1-39ff-44dc-b47f-736552ad46cc");
    }

    public static List<String> getSecondaryParents() {
        return List.of("ec54bbe2-e9f9-4cb3-9f54-7eda18c4cc41", "268a09b8-2f61-4700-8070-16fbc1dc116b");
    }

    public static URI getSource() {
        return URI.create("/f6d21231-618e-4f12-a920-e498660c5b9d");
    }

    public static URI getDataSchema(String schemaName) {
        return URI.create("https://api.alfresco.com/schema/event/repo/v1/" + schemaName);
    }

    public static ZonedDateTime parseTime(String time) {
        return ZonedDateTime.parse(time);
    }

    public static void checkExpectedJsonBody(String expectedJsonBody, String actualJsonBody) throws Exception {
        JSONAssert.assertEquals((String)expectedJsonBody, (String)actualJsonBody, (JSONComparator)JSON_COMPARATOR);
    }
}

