/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import java.util.Collections;
import java.util.List;
import org.alfresco.repo.event.util.RandomModelGenerator;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class NodeResourceTest {
    @Test
    public void setSecondaryParents_populatedListShouldBeStored() {
        List<String> secondaryParents = List.of("parentA", "parentB");
        NodeResource.Builder nodeResourceBuilder = new NodeResource.Builder();
        nodeResourceBuilder.setSecondaryParents(secondaryParents);
        NodeResource nodeResource = nodeResourceBuilder.build();
        Assertions.assertEquals((Object)nodeResource.getSecondaryParents(), secondaryParents, (String)"Unexpected secondary parents.");
    }

    @Test
    public void setSecondaryParents_emptyListShouldBePreserved() {
        NodeResource.Builder nodeResourceBuilder = new NodeResource.Builder();
        nodeResourceBuilder.setSecondaryParents(Collections.emptyList());
        NodeResource nodeResource = nodeResourceBuilder.build();
        Assertions.assertEquals((Object)nodeResource.getSecondaryParents(), Collections.emptyList(), (String)"Expected empty list of secondary parents.");
    }

    @Test
    public void setSecondaryParents_nullListShouldBeStoredAsEmpty() {
        NodeResource.Builder nodeResourceBuilder = new NodeResource.Builder();
        nodeResourceBuilder.setSecondaryParents(null);
        NodeResource nodeResource = nodeResourceBuilder.build();
        Assertions.assertEquals((Object)nodeResource.getSecondaryParents(), Collections.emptyList(), (String)"Expected empty list of secondary parents.");
    }

    @Test
    @DisplayName(value="should correctly clone NodeResource object using toBuilder method")
    void shouldClone() {
        NodeResource src = RandomModelGenerator.generateNodeResource();
        NodeResource dst = src.toBuilder().build();
        Assertions.assertEquals((Object)src, (Object)dst);
    }
}

