/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model.extension;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.alfresco.repo.event.extension.ExtensionAttributes;
import org.alfresco.repo.event.extension.ExtensionAttributesImpl;
import org.alfresco.repo.event.util.TestUtil;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event.v1.model.UserInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventExtensionTest {
    @Test
    public void nodeCreatedEventWithExtensionAttributes_marshalling() throws Exception {
        NodeResource resource = NodeResource.builder().setId(TestUtil.getUUID()).setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(ZonedDateTime.now()).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title", "cm:from", new Date(-2637887000L))).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)resource).build();
        ExtensionAttributesImpl extAttributes = new ExtensionAttributesImpl();
        ExtensionTestObject extObject = new ExtensionTestObject();
        extObject.setId(TestUtil.getUUID());
        extObject.setIntProp(123);
        extObject.setDoubleProp(123.456789);
        extObject.setBoolProp(true);
        extObject.setListProp(List.of("ListElemTest1", "ListElemTest2", "ListElemTest1"));
        extObject.setSetProp(Set.of("SetElemTest1", "SetElemTest2"));
        extObject.setMapProp(Map.of("key1", "Value1", "key2", "Value2"));
        extAttributes.addExtension("extObject", (Object)extObject);
        extAttributes.addExtension("strAttTest", (Object)"Extra Attribute");
        extAttributes.addExtension("intAttTest", (Object)1234);
        extAttributes.addExtension("doubleAttTest", (Object)1234.56789);
        extAttributes.addExtension("boolAttTest", (Object)false);
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType(EventType.NODE_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).setExtensionAttributes((ExtensionAttributes)extAttributes).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("noAuth/NodeCreatedEventWithExtension.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void nodeCreatedEventWithExtensionAttributes_unmarshalling() throws Exception {
        String nodeCreatedEventWithExtAttJson = TestUtil.getResourceFileAsString("noAuth/NodeCreatedEventWithExtension.json");
        Assertions.assertNotNull((Object)nodeCreatedEventWithExtAttJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(nodeCreatedEventWithExtAttJson, (TypeReference)new TypeReference<RepoEvent<EventData<NodeResource>>>(){});
        NodeResource resource = NodeResource.builder().setId("7491120a-e2cb-478f-8599-ebf057cc0c7c").setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(TestUtil.parseTime("2020-04-27T12:37:03.555624+01:00")).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-04-27T12:37:03.557956+01:00")).setProperties(Map.of("cm:title", "test title", "cm:from", "1969-12-01T11:15:13Z")).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        EventData eventData = EventData.builder().setEventGroupId("cb645043-e7d2-4e51-b61d-e6d01582cbab").setResource((Resource)resource).build();
        RepoEvent repoEvent = RepoEvent.builder().setId("97c1b36c-c569-4c66-8a31-7a8d0b6b804a").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-04-27T12:37:03.560134+01:00")).setType(EventType.NODE_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).build();
        Assertions.assertEquals((Object)repoEvent.getId(), (Object)result.getId());
        Assertions.assertEquals((Object)repoEvent.getType(), (Object)result.getType());
        Assertions.assertEquals((Object)repoEvent.getSpecversion(), (Object)result.getSpecversion());
        Assertions.assertEquals((Object)repoEvent.getSource(), (Object)result.getSource());
        Assertions.assertEquals((Object)repoEvent.getTime(), (Object)result.getTime());
        Assertions.assertEquals((Object)repoEvent.getDatacontenttype(), (Object)result.getDatacontenttype());
        Assertions.assertEquals((Object)repoEvent.getDataschema(), (Object)result.getDataschema());
        Assertions.assertEquals((Object)repoEvent.getData(), (Object)result.getData());
        ExtensionAttributes resultExtensionAttributes = result.getExtensionAttributes();
        Assertions.assertNotNull((Object)resultExtensionAttributes, (String)"There should have been an extension.");
        Object extObjectValue = resultExtensionAttributes.getExtension("extObject");
        ExtensionTestObject objectOne = (ExtensionTestObject)TestUtil.OBJECT_MAPPER.readValue(extObjectValue.toString(), ExtensionTestObject.class);
        ExtensionTestObject extObject = new ExtensionTestObject();
        extObject.setId("4cf25559-4c09-4457-96ea-af6c8a569e76");
        extObject.setIntProp(123);
        extObject.setDoubleProp(123.456789);
        extObject.setBoolProp(true);
        extObject.setListProp(List.of("ListElemTest1", "ListElemTest2", "ListElemTest1"));
        extObject.setSetProp(Set.of("SetElemTest1", "SetElemTest2"));
        extObject.setMapProp(Map.of("key1", "Value1", "key2", "Value2"));
        Assertions.assertEquals((Object)extObject, (Object)objectOne);
        Assertions.assertEquals((Object)"Extra Attribute", (Object)resultExtensionAttributes.getExtension("strAttTest"));
        Assertions.assertEquals((Object)1234, (Object)resultExtensionAttributes.getExtension("intAttTest"));
        Assertions.assertEquals((Object)1234.56789, (Object)resultExtensionAttributes.getExtension("doubleAttTest"));
        Assertions.assertEquals((Object)false, (Object)resultExtensionAttributes.getExtension("boolAttTest"));
    }

    public static class ExtensionTestObject {
        private String id;
        private int intProp;
        private double doubleProp;
        private boolean boolProp;
        private List<String> listProp;
        private Set<String> setProp;
        private Map<String, String> mapProp;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getIntProp() {
            return this.intProp;
        }

        public void setIntProp(int intProp) {
            this.intProp = intProp;
        }

        public double getDoubleProp() {
            return this.doubleProp;
        }

        public void setDoubleProp(double doubleProp) {
            this.doubleProp = doubleProp;
        }

        public boolean isBoolProp() {
            return this.boolProp;
        }

        public void setBoolProp(boolean boolProp) {
            this.boolProp = boolProp;
        }

        public List<String> getListProp() {
            return this.listProp;
        }

        public void setListProp(List<String> listProp) {
            this.listProp = listProp;
        }

        public Set<String> getSetProp() {
            return this.setProp;
        }

        public void setSetProp(Set<String> setProp) {
            this.setProp = setProp;
        }

        public Map<String, String> getMapProp() {
            return this.mapProp;
        }

        public void setMapProp(Map<String, String> mapProp) {
            this.mapProp = mapProp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtensionTestObject)) {
                return false;
            }
            ExtensionTestObject that = (ExtensionTestObject)o;
            return this.getIntProp() == that.getIntProp() && Double.compare(that.getDoubleProp(), this.getDoubleProp()) == 0 && this.isBoolProp() == that.isBoolProp() && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getListProp(), that.getListProp()) && Objects.equals(this.getSetProp(), that.getSetProp()) && Objects.equals(this.getMapProp(), that.getMapProp());
        }

        public int hashCode() {
            return Objects.hash(this.getId(), this.getIntProp(), this.getDoubleProp(), this.isBoolProp(), this.getListProp(), this.getSetProp(), this.getMapProp());
        }
    }
}

