/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.alfresco.repo.event.databind.EventDeserializerException;

public class DateTimeDeserializer
extends StdDeserializer<ZonedDateTime> {
    private static final long serialVersionUID = -4795816764531735401L;

    public DateTimeDeserializer() {
        this(null);
    }

    public DateTimeDeserializer(Class<?> valueClass) {
        super(valueClass);
    }

    public ZonedDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        try {
            return ZonedDateTime.parse(jsonParser.getText(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (DateTimeException ex) {
            throw new EventDeserializerException("The text cannot be parsed to ZonedDateTime time.");
        }
    }
}

