/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.databind;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.ZonedDateTime;
import java.util.Date;
import org.alfresco.repo.event.databind.DateSerializer;
import org.alfresco.repo.event.databind.DateTimeDeserializer;
import org.alfresco.repo.event.databind.DateTimeSerializer;
import org.alfresco.repo.event.extension.ExtensionAttributes;
import org.alfresco.repo.event.extension.ExtensionAttributesImpl;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;

public class ObjectMapperFactory {
    public static ObjectMapper createInstance() {
        return new ObjectMapperFactory().createObjectMapper();
    }

    public ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = this.getSimpleModule();
        SimpleAbstractTypeResolver resolver = this.getSimpleAbstractTypeResolver();
        if (resolver != null) {
            resolver.addMapping(ExtensionAttributes.class, ExtensionAttributesImpl.class);
            module.setAbstractTypes(resolver);
        }
        mapper.registerModule((Module)module);
        return mapper;
    }

    protected SimpleModule getSimpleModule() {
        SimpleModule module = new SimpleModule("Resource Serializer-Deserializer", new Version(0, 1, 0, "", "", ""));
        module.addSerializer(ZonedDateTime.class, (JsonSerializer)new DateTimeSerializer());
        module.addDeserializer(ZonedDateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer());
        return module;
    }

    protected SimpleAbstractTypeResolver getSimpleAbstractTypeResolver() {
        SimpleAbstractTypeResolver resolver = new SimpleAbstractTypeResolver();
        resolver.addMapping(DataAttributes.class, EventData.class);
        return resolver;
    }
}

