/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.event.util.RandomModelGenerator;
import org.alfresco.repo.event.util.TestUtil;
import org.alfresco.repo.event.v1.model.AuditEntryResource;
import org.alfresco.repo.event.v1.model.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event.v1.model.UserInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class EventTest {
    @Test
    public void nodeCreatedEvent_marshalling() throws Exception {
        NodeResource resource = NodeResource.builder().setId(TestUtil.getUUID()).setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(ZonedDateTime.now()).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title", "cm:from", new Date(-2637887000L))).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mich an", Locale.ENGLISH.getLanguage(), "call me"))).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).setSecondaryParents(TestUtil.getSecondaryParents()).build();
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)resource).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType(EventType.NODE_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("noAuth/NodeCreatedEvent.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void nodeCreatedEvent_unmarshalling() throws Exception {
        String nodeCreatedEventJson = TestUtil.getResourceFileAsString("noAuth/NodeCreatedEvent.json");
        Assertions.assertNotNull((Object)nodeCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(nodeCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<NodeResource>>>(){});
        NodeResource resource = NodeResource.builder().setId("7491120a-e2cb-478f-8599-ebf057cc0c7c").setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(TestUtil.parseTime("2020-04-27T12:37:03.555624+01:00")).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-04-27T12:37:03.557956+01:00")).setProperties(Map.of("cm:title", "test title", "cm:from", "1969-12-01T11:15:13Z")).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mich an", Locale.ENGLISH.getLanguage(), "call me"))).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).setSecondaryParents(TestUtil.getSecondaryParents()).build();
        EventData eventData = EventData.builder().setEventGroupId("cb645043-e7d2-4e51-b61d-e6d01582cbab").setResource((Resource)resource).build();
        RepoEvent repoEvent = RepoEvent.builder().setId("97c1b36c-c569-4c66-8a31-7a8d0b6b804a").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-04-27T12:37:03.560134+01:00")).setType(EventType.NODE_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).build();
        Assertions.assertEquals((Object)repoEvent, (Object)result);
    }

    @Test
    public void nodeUpdatedEvent_marshalling() throws Exception {
        NodeResource resource = NodeResource.builder().setId(TestUtil.getUUID()).setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(ZonedDateTime.now()).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title2", "cm:description", "test description.")).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mich an", Locale.ENGLISH.getLanguage(), "call me"))).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).setSecondaryParents(TestUtil.getSecondaryParents()).build();
        NodeResource resourceBefore = NodeResource.builder().setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title")).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mi an"))).build();
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)resource).setResourceBefore((Resource)resourceBefore).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType(EventType.NODE_UPDATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeUpdated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("noAuth/NodeUpdatedEvent.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void nodeUpdatedEvent_unmarshalling() throws Exception {
        String nodeUpdatedEventJson = TestUtil.getResourceFileAsString("noAuth/NodeUpdatedEvent.json");
        Assertions.assertNotNull((Object)nodeUpdatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(nodeUpdatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<NodeResource>>>(){});
        NodeResource expectedResource = NodeResource.builder().setId("d366f805-853f-46ac-a81c-af9c257ee876").setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(TestUtil.parseTime("2020-04-27T14:25:59.852475+01:00")).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-04-27T14:25:59.854153+01:00")).setProperties(Map.of("cm:title", "test title2", "cm:description", "test description.")).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mich an", Locale.ENGLISH.getLanguage(), "call me"))).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).setSecondaryParents(TestUtil.getSecondaryParents()).build();
        NodeResource expectedResourceBefore = NodeResource.builder().setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-04-27T14:25:59.854558+01:00")).setProperties(Map.of("cm:title", "test title")).setLocalizedProperties(Map.of("cm:description", Map.of(Locale.GERMAN.getLanguage(), "ruf mi an"))).build();
        EventData expectedEventData = EventData.builder().setEventGroupId("ce852a52-609e-4b7d-8438-04e211fd76a0").setResource((Resource)expectedResource).setResourceBefore((Resource)expectedResourceBefore).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("df708027-e0a8-4b30-92a5-0d19235a7800").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-04-27T14:25:59.855866+01:00")).setType(EventType.NODE_UPDATED.getType()).setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("nodeUpdated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void childAssocCreatedEvent_marshalling() throws Exception {
        ChildAssociationResource childAssocResource = new ChildAssociationResource(TestUtil.getUUID(), TestUtil.getUUID(), "cm:contains", "cm:213131-1234-1235-5432-12039400a121");
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)childAssocResource).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType(EventType.CHILD_ASSOC_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("childAssocCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("noAuth/ChildAssocCreated.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void childAssocCreatedEvent_unmarshalling() throws Exception {
        String childAssocCreatedEventJson = TestUtil.getResourceFileAsString("noAuth/ChildAssocCreated.json");
        Assertions.assertNotNull((Object)childAssocCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(childAssocCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<ChildAssociationResource>>>(){});
        ChildAssociationResource expectedResource = new ChildAssociationResource("7624edb6-6f28-4130-a4fb-4a5362807a05", "5d9f3d6f-9802-4bb6-8ad3-0f9261d08894", "cm:contains", "cm:213131-1234-1235-5432-12039400a121");
        EventData expectedEventData = EventData.builder().setEventGroupId("d933857e-5f4f-406e-aa5f-c747901f5a8f").setResource((Resource)expectedResource).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("928c28fc-da23-441d-bb8b-72b068a9ceb5").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-05-28T09:56:52.235411+01:00")).setType(EventType.CHILD_ASSOC_CREATED.getType()).setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("childAssocCreated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void peerAssocCreatedEvent_marshalling() throws Exception {
        PeerAssociationResource peerAssocResource = new PeerAssociationResource(TestUtil.getUUID(), TestUtil.getUUID(), "cm:references");
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)peerAssocResource).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType(EventType.PEER_ASSOC_CREATED.getType()).setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("peerAssocCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("noAuth/PeerAssocCreated.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void peerAssocCreatedEvent_unmarshalling() throws Exception {
        String peerAssocCreatedEventJson = TestUtil.getResourceFileAsString("noAuth/PeerAssocCreated.json");
        Assertions.assertNotNull((Object)peerAssocCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(peerAssocCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<PeerAssociationResource>>>(){});
        PeerAssociationResource expectedResource = new PeerAssociationResource("d323671c-9bd0-483e-8471-bd64cea73c09", "595c55b0-64b3-4f1b-95f8-c1cc6b3843a2", "cm:references");
        EventData expectedEventData = EventData.builder().setEventGroupId("b23f75d0-45da-40d1-9063-eb800a4f2444").setResource((Resource)expectedResource).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("8677a369-a30d-469e-b313-e5bf1b590c8e").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-05-28T10:36:21.291392+01:00")).setType(EventType.PEER_ASSOC_CREATED.getType()).setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("peerAssocCreated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void nodeCreatedWithAuthoritiesEvent_marshalling() throws Exception {
        NodeResource resource = NodeResource.builder().setId(TestUtil.getUUID()).setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(ZonedDateTime.now()).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title")).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)resource).setResourceReaderAuthorities(Set.of("GROUP_EVERYONE", "GROUP_ONE", "GROUP_TWO")).setResourceDeniedAuthorities(Set.of()).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType("org.alfresco.event.node.Created").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("auth/NodeCreatedEvent.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void nodeCreatedWithAuthoritiesEvent_unmarshalling() throws Exception {
        String nodeCreatedEventJson = TestUtil.getResourceFileAsString("auth/NodeCreatedEvent.json");
        Assertions.assertNotNull((Object)nodeCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(nodeCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<NodeResource>>>(){});
        NodeResource resource = NodeResource.builder().setId("7491120a-e2cb-478f-8599-ebf057cc0c7c").setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(TestUtil.parseTime("2020-06-10T12:37:03.555624+01:00")).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-06-10T12:37:03.557956+01:00")).setProperties(Map.of("cm:title", "test title")).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        EventData eventData = EventData.builder().setEventGroupId("cb645043-e7d2-4e51-b61d-e6d01582cbab").setResource((Resource)resource).setResourceReaderAuthorities(Set.of("GROUP_EVERYONE", "GROUP_ONE", "GROUP_TWO")).setResourceDeniedAuthorities(Set.of()).build();
        RepoEvent repoEvent = RepoEvent.builder().setId("97c1b36c-c569-4c66-8a31-7a8d0b6b804a").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-06-10T12:37:03.560134+01:00")).setType("org.alfresco.event.node.Created").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeCreated")).build();
        Assertions.assertEquals((Object)repoEvent, (Object)result);
    }

    @Test
    public void nodeUpdatedWithAuthoritiesEvent_marshalling() throws Exception {
        NodeResource resource = NodeResource.builder().setId(TestUtil.getUUID()).setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setPrimaryAssocQName("cm:testFile.txt").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(ZonedDateTime.now()).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title2", "cm:description", "test description.")).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        NodeResource resourceBefore = NodeResource.builder().setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(ZonedDateTime.now()).setProperties(Map.of("cm:title", "test title")).build();
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)resource).setResourceBefore((Resource)resourceBefore).setResourceReaderAuthorities(Set.of("GROUP_ONE", "GROUP_THREE")).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).setResourceReaderSecurityControls(Set.of("e428663f-9171-42e2-b233-d8f2cd3f54f7:mF2foUuA")).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType("org.alfresco.event.node.Updated").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("nodeUpdated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("auth/NodeUpdatedEvent.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void nodeUpdatedWithAuthoritiesEvent_unmarshalling() throws Exception {
        String nodeUpdatedEventJson = TestUtil.getResourceFileAsString("auth/NodeUpdatedEvent.json");
        Assertions.assertNotNull((Object)nodeUpdatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(nodeUpdatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<NodeResource>>>(){});
        NodeResource expectedResource = NodeResource.builder().setId("d366f805-853f-46ac-a81c-af9c257ee876").setName("testFile.txt").setPrimaryHierarchy(TestUtil.getTestNodePrimaryHierarchy()).setIsFile(Boolean.valueOf(true)).setIsFolder(Boolean.valueOf(false)).setNodeType("cm:content").setCreatedByUser(new UserInfo("john.doe", "John", "Doe")).setCreatedAt(TestUtil.parseTime("2020-06-10T14:25:59.852475+01:00")).setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-06-10T14:25:59.854153+01:00")).setProperties(Map.of("cm:title", "test title2", "cm:description", "test description.")).setAspectNames(Set.of("cm:titled", "cm:auditable")).setContent(new ContentInfo("text/plain", Long.valueOf(16L), "UTF-8")).build();
        NodeResource expectedResourceBefore = NodeResource.builder().setModifiedByUser(new UserInfo("jane.doe", "Jane", "Doe")).setModifiedAt(TestUtil.parseTime("2020-06-10T14:25:59.854558+01:00")).setProperties(Map.of("cm:title", "test title")).build();
        EventData expectedEventData = EventData.builder().setEventGroupId("ce852a52-609e-4b7d-8438-04e211fd76a0").setResource((Resource)expectedResource).setResourceBefore((Resource)expectedResourceBefore).setResourceReaderAuthorities(Set.of("GROUP_ONE", "GROUP_THREE")).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).setResourceReaderSecurityControls(Set.of("e428663f-9171-42e2-b233-d8f2cd3f54f7:mF2foUuA")).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("df708027-e0a8-4b30-92a5-0d19235a7800").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-06-10T14:25:59.855866+01:00")).setType("org.alfresco.event.node.Updated").setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("nodeUpdated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void childAssocCreatedWithAuthoritiesEvent_marshalling() throws Exception {
        ChildAssociationResource childAssocResource = new ChildAssociationResource(TestUtil.getUUID(), TestUtil.getUUID(), "cm:contains", "cm:213131-1234-1235-5432-12039400a121");
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)childAssocResource).setResourceReaderAuthorities(Set.of("GROUP_EVERYONE", "GROUP_ONE")).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType("org.alfresco.event.assoc.child.Created").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("childAssocCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("auth/ChildAssocCreated.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void childAssocCreatedWithAuthoritiesEvent_unmarshalling() throws Exception {
        String childAssocCreatedEventJson = TestUtil.getResourceFileAsString("auth/ChildAssocCreated.json");
        Assertions.assertNotNull((Object)childAssocCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(childAssocCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<ChildAssociationResource>>>(){});
        ChildAssociationResource expectedResource = new ChildAssociationResource("7624edb6-6f28-4130-a4fb-4a5362807a05", "5d9f3d6f-9802-4bb6-8ad3-0f9261d08894", "cm:contains", "cm:213131-1234-1235-5432-12039400a121");
        EventData expectedEventData = EventData.builder().setEventGroupId("d933857e-5f4f-406e-aa5f-c747901f5a8f").setResource((Resource)expectedResource).setResourceReaderAuthorities(Set.of("GROUP_EVERYONE", "GROUP_ONE")).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("928c28fc-da23-441d-bb8b-72b068a9ceb5").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-06-10T09:56:52.235411+01:00")).setType("org.alfresco.event.assoc.child.Created").setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("childAssocCreated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void peerAssocCreatedWithAuthoritiesEvent_marshalling() throws Exception {
        PeerAssociationResource peerAssocResource = new PeerAssociationResource(TestUtil.getUUID(), TestUtil.getUUID(), "cm:references");
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)peerAssocResource).setResourceReaderAuthorities(Set.of()).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType("org.alfresco.event.assoc.peer.Created").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("peerAssocCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("auth/PeerAssocCreated.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void peerAssocCreatedWithAuthoritiesEvent_unmarshalling() throws Exception {
        String peerAssocCreatedEventJson = TestUtil.getResourceFileAsString("auth/PeerAssocCreated.json");
        Assertions.assertNotNull((Object)peerAssocCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(peerAssocCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<PeerAssociationResource>>>(){});
        PeerAssociationResource expectedResource = new PeerAssociationResource("d323671c-9bd0-483e-8471-bd64cea73c09", "595c55b0-64b3-4f1b-95f8-c1cc6b3843a2", "cm:references");
        EventData expectedEventData = EventData.builder().setEventGroupId("b23f75d0-45da-40d1-9063-eb800a4f2444").setResource((Resource)expectedResource).setResourceReaderAuthorities(Set.of()).setResourceDeniedAuthorities(Set.of("GROUP_TWO")).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("8677a369-a30d-469e-b313-e5bf1b590c8e").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-06-10T10:36:21.291392+01:00")).setType("org.alfresco.event.assoc.peer.Created").setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("peerAssocCreated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void auditEntryEvent_marshalling() throws Exception {
        Map<String, ArrayList<String>> auditData = Map.of("somekey", "somevalue", "anotherkey", new ArrayList<String>(List.of("firstvalue", "secondvalue")));
        EventData eventData = EventData.builder().setEventGroupId(TestUtil.getUUID()).setResource((Resource)new AuditEntryResource("auditedApp", "admin", Long.valueOf(1L), auditData)).build();
        RepoEvent repoEvent = RepoEvent.builder().setId(TestUtil.getUUID()).setSource(TestUtil.getSource()).setTime(ZonedDateTime.now()).setType("org.alfresco.event.audit.entry.Created").setData((DataAttributes)eventData).setDataschema(TestUtil.getDataSchema("auditEntryCreated")).build();
        String result = TestUtil.OBJECT_MAPPER.writeValueAsString((Object)repoEvent);
        String expectedJson = TestUtil.getResourceFileAsString("AuditEntryCreated.json");
        TestUtil.checkExpectedJsonBody(expectedJson, result);
    }

    @Test
    public void auditEntryEvent_unmarshalling() throws Exception {
        String auditEntryEventJson = TestUtil.getResourceFileAsString("AuditEntryCreated.json");
        Assertions.assertNotNull((Object)auditEntryEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(auditEntryEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<AuditEntryResource>>>(){});
        Map<String, ArrayList<String>> auditData = Map.of("somekey", "somevalue", "anotherkey", new ArrayList<String>(List.of("firstvalue", "secondvalue")));
        EventData expectedEventData = EventData.builder().setEventGroupId("b23f75d0-45da-40d1-9063-eb800a4f2444").setResource((Resource)new AuditEntryResource("auditedApp", "admin", Long.valueOf(1L), auditData)).build();
        RepoEvent expectedRepoEvent = RepoEvent.builder().setId("8877b428-da23-441d-bb8b-e5bf1b59abfe").setSource(TestUtil.getSource()).setTime(TestUtil.parseTime("2020-06-10T09:56:52.235411+01:00")).setType("org.alfresco.event.audit.entry.Created").setData((DataAttributes)expectedEventData).setDataschema(TestUtil.getDataSchema("auditEntryCreated")).build();
        Assertions.assertEquals((Object)expectedRepoEvent, (Object)result);
    }

    @Test
    public void nonExistingResource_unmarshalling() throws Exception {
        String peerAssocCreatedEventJson = TestUtil.getResourceFileAsString("NonExistingResource.json");
        Assertions.assertNotNull((Object)peerAssocCreatedEventJson);
        RepoEvent result = (RepoEvent)TestUtil.OBJECT_MAPPER.readValue(peerAssocCreatedEventJson, (TypeReference)new TypeReference<RepoEvent<EventData<Resource>>>(){});
        Assertions.assertNull((Object)((EventData)result.getData()).getResource());
    }

    @Test
    @DisplayName(value="should correctly clone RepoEvent object using toBuilder method")
    void shouldClone() {
        RepoEvent src = RandomModelGenerator.generateRepoEvent();
        RepoEvent dst = src.toBuilder().build();
        Assertions.assertEquals(src, (Object)dst);
    }
}

