/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import java.util.Optional;
import org.alfresco.repo.event.v1.model.EventType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EventTypeTest {
    EventTypeTest() {
    }

    @Test
    void shouldReturnOptionalWithEventTypeFromTypeStringForAllEventTypes() {
        for (EventType expected : EventType.values()) {
            String type = expected.getType();
            Optional actual = EventType.findByType((String)type);
            Assertions.assertTrue((boolean)actual.isPresent());
            Assertions.assertEquals((Object)expected, actual.get());
        }
    }

    @Test
    void shouldReturnEmptyOptionalWhenTypeStringIsNotMatchingAnyEventType() {
        String type = "wrong.type";
        Optional actual = EventType.findByType((String)type);
        Assertions.assertFalse((boolean)actual.isPresent());
    }
}

