/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model.schema.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.Resource;
import org.alfresco.repo.event.v1.model.schema.ChildAssociationResource;
import org.alfresco.repo.event.v1.model.schema.EventDataWithResourceBefore;
import org.alfresco.repo.event.v1.model.schema.EventDataWithoutResourceBefore;
import org.alfresco.repo.event.v1.model.schema.NodeResource;
import org.alfresco.repo.event.v1.model.schema.PeerAssociationResource;
import org.alfresco.repo.event.v1.model.schema.RepoEvent;
import org.alfresco.repo.event.v1.model.schema.Required;
import org.junit.jupiter.api.Test;

public class JsonSchemaGeneratorTest {
    @Test
    public void jsonSchema() {
        for (EventEntry entry : EventEntry.values()) {
            SchemaGeneratorConfigBuilder configBuilder = this.getConfigBuilder(entry);
            SchemaGeneratorConfig config = configBuilder.build();
            SchemaGenerator generator = new SchemaGenerator(config);
            ObjectNode jsonSchema = generator.generateSchema(RepoEvent.class, new Type[0]);
            entry.fileNames.forEach(arg_0 -> this.lambda$jsonSchema$0((JsonNode)jsonSchema, arg_0));
        }
    }

    private SchemaGeneratorConfigBuilder getConfigBuilder(EventEntry entry) {
        JacksonModule module = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_ORDER});
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2019_09, OptionPreset.PLAIN_JSON).with((Module)module);
        configBuilder.forTypesInGeneral().withSubtypeResolver((declaredType, generationContext) -> {
            TypeContext typeContext;
            if (declaredType.getErasedType() == Resource.class) {
                typeContext = generationContext.getTypeContext();
                switch (entry) {
                    case NODE_ENTRY: {
                        return List.of(typeContext.resolveSubtype(declaredType, NodeResource.class));
                    }
                    case CHILD_ASSOC_ENTRY: {
                        return List.of(typeContext.resolveSubtype(declaredType, ChildAssociationResource.class));
                    }
                    case PEER_ASSOC_ENTRY: {
                        return List.of(typeContext.resolveSubtype(declaredType, PeerAssociationResource.class));
                    }
                }
            }
            if (declaredType.getErasedType() == DataAttributes.class) {
                typeContext = generationContext.getTypeContext();
                if (entry == EventEntry.NODE_UPDATED_ENTRY) {
                    return List.of(typeContext.resolveSubtype(declaredType, EventDataWithResourceBefore.class));
                }
                return List.of(typeContext.resolveSubtype(declaredType, EventDataWithoutResourceBefore.class));
            }
            return null;
        });
        configBuilder.forFields().withTargetTypeOverridesResolver(field -> {
            if (field.getDeclaredType().getErasedType() == URI.class) {
                return Stream.of(String.class).map(specificSubtype -> field.getContext().resolve(String.class, new Type[0])).collect(Collectors.toList());
            }
            return null;
        });
        configBuilder.forFields().withRequiredCheck(field -> {
            Required annotation = (Required)field.getAnnotation(Required.class);
            return annotation != null;
        });
        return configBuilder;
    }

    private void writeToFile(JsonNode jsonSchema, String fileName) {
        File outputDir = new File("target/schema/");
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try (FileOutputStream outputStream = new FileOutputStream(new File(outputDir, fileName));
             PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
            writer.print(jsonSchema.toPrettyString());
        }
        catch (IOException e) {
            throw new RuntimeException("Error: Can not write to file " + fileName, e);
        }
    }

    private /* synthetic */ void lambda$jsonSchema$0(JsonNode jsonSchema, String file) {
        this.writeToFile(jsonSchema, file);
    }

    static enum EventEntry {
        NODE_ENTRY(List.of("nodeCreated.json", "nodeDeleted.json")),
        NODE_UPDATED_ENTRY(List.of("nodeUpdated.json")),
        CHILD_ASSOC_ENTRY(List.of("childAssocCreated.json", "childAssocDeleted.json")),
        PEER_ASSOC_ENTRY(List.of("peerAssocCreated.json", "peerAssocDeleted.json"));

        private final List<String> fileNames;

        private EventEntry(List<String> fileNames) {
            this.fileNames = fileNames;
        }
    }
}

