/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Objects;
import java.util.Set;
import org.alfresco.repo.event.util.EventDataUtils;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.Resource;

@JsonDeserialize(builder=Builder.class)
public class EventData<R extends Resource>
implements DataAttributes<R> {
    private final String eventGroupId;
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private final R resource;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
    private final R resourceBefore;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Set<String> resourceReaderAuthorities;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Set<String> resourceDeniedAuthorities;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Set<String> resourceReaderSecurityControls;

    private EventData(Builder<R> builder) {
        this.eventGroupId = builder.eventGroupId;
        this.resource = builder.resource;
        this.resourceBefore = builder.resourceBefore;
        this.resourceReaderAuthorities = builder.resourceReaderAuthorities;
        this.resourceDeniedAuthorities = builder.resourceDeniedAuthorities;
        this.resourceReaderSecurityControls = builder.resourceReaderSecurityControls;
    }

    public static <R extends Resource> Builder<R> builder() {
        return new Builder();
    }

    @Override
    public String getEventGroupId() {
        return this.eventGroupId;
    }

    @Override
    public R getResource() {
        return this.resource;
    }

    @Override
    public R getResourceBefore() {
        return this.resourceBefore;
    }

    public Set<String> getResourceReaderAuthorities() {
        return this.resourceReaderAuthorities;
    }

    public Set<String> getResourceDeniedAuthorities() {
        return this.resourceDeniedAuthorities;
    }

    public Set<String> getResourceReaderSecurityControls() {
        return this.resourceReaderSecurityControls;
    }

    public Builder<R> toBuilder() {
        return EventDataUtils.getFilledBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventData)) {
            return false;
        }
        EventData that = (EventData)o;
        return Objects.equals(this.eventGroupId, that.eventGroupId) && Objects.equals(this.resource, that.resource) && Objects.equals(this.resourceBefore, that.resourceBefore) && Objects.equals(this.resourceReaderAuthorities, that.resourceReaderAuthorities) && Objects.equals(this.resourceDeniedAuthorities, that.resourceDeniedAuthorities) && Objects.equals(this.resourceReaderSecurityControls, that.resourceReaderSecurityControls);
    }

    public int hashCode() {
        return Objects.hash(this.eventGroupId, this.resource, this.resourceBefore, this.resourceReaderAuthorities, this.resourceDeniedAuthorities, this.resourceReaderSecurityControls);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("EventData [eventGroupId=").append(this.eventGroupId).append(", resource=").append(this.resource).append(", resourceBefore=").append(this.resourceBefore).append(", resourceReaderAuthorities=").append(this.resourceReaderAuthorities).append(", resourceDeniedAuthorities=").append(this.resourceDeniedAuthorities).append(", resourceReaderSecurityControls=").append(this.resourceReaderSecurityControls).append(']');
        return sb.toString();
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder<R extends Resource> {
        private String eventGroupId;
        private R resource;
        private R resourceBefore;
        private Set<String> resourceReaderAuthorities;
        private Set<String> resourceDeniedAuthorities;
        private Set<String> resourceReaderSecurityControls;

        public Builder<R> setEventGroupId(String eventGroupId) {
            this.eventGroupId = eventGroupId;
            return this;
        }

        public Builder<R> setResource(R resource) {
            this.resource = resource;
            return this;
        }

        public Builder<R> setResourceBefore(R resourceBefore) {
            this.resourceBefore = resourceBefore;
            return this;
        }

        public Builder<R> setResourceReaderAuthorities(Set<String> resourceReaderAuthorities) {
            this.resourceReaderAuthorities = resourceReaderAuthorities;
            return this;
        }

        public Builder<R> setResourceDeniedAuthorities(Set<String> resourceDeniedAuthorities) {
            this.resourceDeniedAuthorities = resourceDeniedAuthorities;
            return this;
        }

        public Builder<R> setResourceReaderSecurityControls(Set<String> resourceReaderSecurityControls) {
            this.resourceReaderSecurityControls = resourceReaderSecurityControls;
            return this;
        }

        public EventData<R> build() {
            return new EventData(this);
        }
    }
}

