/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.alfresco.repo.event.EventAttributes;
import org.alfresco.repo.event.extension.ExtensionAttributes;
import org.alfresco.repo.event.util.RepoEventUtils;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.Resource;

@JsonDeserialize(builder=Builder.class)
public class RepoEvent<D extends DataAttributes<? extends Resource>>
implements EventAttributes {
    private static final String SPEC_VERSION = "1.0";
    private static final String CONTENT_TYPE = "application/json";
    private final String specversion;
    private final String type;
    private final String id;
    private final URI source;
    private final ZonedDateTime time;
    private final URI dataschema;
    private final String datacontenttype;
    private final D data;
    private final ExtensionAttributes extensionAttributes;

    protected RepoEvent(Builder<D> builder) {
        this.specversion = builder.specversion;
        this.type = builder.type;
        this.id = builder.id;
        this.source = builder.source;
        this.time = builder.time;
        this.datacontenttype = builder.datacontenttype;
        this.data = builder.data;
        this.dataschema = builder.dataschema;
        this.extensionAttributes = builder.extensionAttributes;
    }

    public static <D extends DataAttributes<? extends Resource>> Builder<D> builder() {
        return new Builder();
    }

    @Override
    public String getSpecversion() {
        return this.specversion;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public URI getSource() {
        return this.source;
    }

    @Override
    public ZonedDateTime getTime() {
        return this.time;
    }

    @Override
    public URI getDataschema() {
        return this.dataschema;
    }

    @Override
    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public D getData() {
        return this.data;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ExtensionAttributes getExtensionAttributes() {
        return this.extensionAttributes;
    }

    public Builder<D> toBuilder() {
        return RepoEventUtils.getFilledBuilder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepoEvent)) {
            return false;
        }
        RepoEvent repoEvent = (RepoEvent)o;
        return Objects.equals(this.specversion, repoEvent.specversion) && Objects.equals(this.type, repoEvent.type) && Objects.equals(this.id, repoEvent.id) && Objects.equals(this.source, repoEvent.source) && Objects.equals(this.dataschema, repoEvent.dataschema) && Objects.equals(this.time, repoEvent.time) && Objects.equals(this.datacontenttype, repoEvent.datacontenttype) && Objects.equals(this.data, repoEvent.data) && Objects.equals(this.extensionAttributes, repoEvent.extensionAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.specversion, this.type, this.id, this.source, this.dataschema, this.time, this.datacontenttype, this.data, this.extensionAttributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("RepoEvent [specversion=").append(this.specversion).append(", type=").append(this.type).append(", id=").append(this.id).append(", source=").append(this.source).append(", time=").append(this.time).append(", dataschema=").append(this.dataschema).append(", datacontenttype=").append(this.datacontenttype).append(", data=").append(this.data).append(", extensionAttributes=").append(this.extensionAttributes).append(']');
        return sb.toString();
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder<D extends DataAttributes<? extends Resource>> {
        private String specversion = "1.0";
        private String type;
        private String id;
        private URI source;
        private ZonedDateTime time;
        private URI dataschema;
        private String datacontenttype = "application/json";
        private D data;
        private ExtensionAttributes extensionAttributes;

        public Builder<D> setSpecversion(String specversion) {
            this.specversion = specversion;
            return this;
        }

        public Builder<D> setType(String type) {
            this.type = type;
            return this;
        }

        public Builder<D> setId(String id) {
            this.id = id;
            return this;
        }

        public Builder<D> setSource(URI source) {
            this.source = source;
            return this;
        }

        public Builder<D> setTime(ZonedDateTime time) {
            this.time = time;
            return this;
        }

        public Builder<D> setDataschema(URI dataschema) {
            this.dataschema = dataschema;
            return this;
        }

        public Builder<D> setDatacontenttype(String datacontenttype) {
            this.datacontenttype = datacontenttype;
            return this;
        }

        public Builder<D> setData(D data) {
            this.data = data;
            return this;
        }

        public Builder<D> setExtensionAttributes(ExtensionAttributes extensionAttributes) {
            this.extensionAttributes = extensionAttributes;
            return this;
        }

        public RepoEvent<D> build() {
            return new RepoEvent(this);
        }
    }
}

