/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.alfresco.repo.event.extension.ExtensionAttributes;
import org.alfresco.repo.event.extension.ExtensionAttributesImpl;

public class ExtensionDeserializer
extends JsonDeserializer<ExtensionAttributes> {
    public ExtensionAttributes deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ObjectCodec objectCodec = parser.getCodec();
        JsonNode jsonNode = (JsonNode)objectCodec.readTree(parser);
        ExtensionAttributesImpl extension = new ExtensionAttributesImpl();
        jsonNode.fields().forEachRemaining(entry -> {
            String extName = (String)entry.getKey();
            JsonNode extValue = (JsonNode)entry.getValue();
            switch (extValue.getNodeType()) {
                case STRING: {
                    extension.addExtension(extName, extValue.textValue());
                    break;
                }
                case NUMBER: {
                    extension.addExtension(extName, extValue.numberValue());
                    break;
                }
                case BOOLEAN: {
                    extension.addExtension(extName, extValue.booleanValue());
                    break;
                }
                default: {
                    extension.addExtension(extName, extValue.toString());
                }
            }
        });
        return extension;
    }
}

