/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import java.util.Arrays;
import java.util.Optional;

public enum EventType {
    NODE_CREATED("Created", ContextType.NODE),
    NODE_UPDATED("Updated", ContextType.NODE),
    NODE_DELETED("Deleted", ContextType.NODE),
    CHILD_ASSOC_CREATED("Created", ContextType.CHILD_ASSOC),
    CHILD_ASSOC_DELETED("Deleted", ContextType.CHILD_ASSOC),
    PEER_ASSOC_CREATED("Created", ContextType.PEER_ASSOC),
    PEER_ASSOC_DELETED("Deleted", ContextType.PEER_ASSOC),
    PERMISSION_UPDATED("Updated", ContextType.PERMISSION),
    AUDIT_ENTRY_CREATED("Created", ContextType.AUDIT_ENTRY);

    private static final String PREFIX = "org.alfresco.event.";
    private final String type;
    private final ContextType contextType;

    private EventType(String type, ContextType contextType) {
        this.type = type;
        this.contextType = contextType;
    }

    String getContext() {
        return this.contextType.getContext();
    }

    public String toString() {
        return PREFIX + this.getContext() + this.type;
    }

    public String getType() {
        return this.toString();
    }

    public static Optional<EventType> findByType(String type) {
        return Arrays.stream(EventType.values()).filter(eventType -> eventType.getType().equals(type)).findFirst();
    }

    private static enum ContextType {
        NODE("node."),
        CHILD_ASSOC("assoc.child."),
        PEER_ASSOC("assoc.peer."),
        PERMISSION("permission."),
        AUDIT_ENTRY("audit.entry.");

        private final String context;

        private ContextType(String context) {
            this.context = context;
        }

        String getContext() {
            return this.context;
        }
    }

    private static class EventTypeConst {
        private static final String CREATED = "Created";
        private static final String UPDATED = "Updated";
        private static final String DELETED = "Deleted";

        private EventTypeConst() {
        }
    }
}

