/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event.v1.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.alfresco.repo.event.util.NodeResourceUtils;
import org.alfresco.repo.event.v1.model.AbstractNodeResource;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.UserInfo;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class NodeResource
extends AbstractNodeResource {
    private final String name;
    private final String nodeType;
    private final Boolean isFile;
    private final Boolean isFolder;
    private final UserInfo createdByUser;
    private final ZonedDateTime createdAt;
    private final UserInfo modifiedByUser;
    private final ZonedDateTime modifiedAt;
    private final ContentInfo content;
    private final Map<String, Serializable> properties;
    private final Map<String, Map<String, String>> localizedProperties;
    private final Set<String> aspectNames;
    private final String primaryAssocQName;
    private final List<String> secondaryParents;

    private NodeResource(Builder builder) {
        super(builder.id, builder.primaryHierarchy);
        this.name = builder.name;
        this.nodeType = builder.nodeType;
        this.isFile = builder.isFile;
        this.isFolder = builder.isFolder;
        this.createdByUser = builder.createdByUser;
        this.createdAt = builder.createdAt;
        this.modifiedByUser = builder.modifiedByUser;
        this.modifiedAt = builder.modifiedAt;
        this.content = builder.content;
        this.properties = builder.properties;
        this.localizedProperties = builder.localizedProperties;
        this.aspectNames = builder.aspectNames;
        this.primaryAssocQName = builder.primaryAssocQName;
        this.secondaryParents = builder.secondaryParents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    @JsonProperty(value="isFile")
    public Boolean isFile() {
        return this.isFile;
    }

    @JsonProperty(value="isFolder")
    public Boolean isFolder() {
        return this.isFolder;
    }

    public UserInfo getCreatedByUser() {
        return this.createdByUser;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public UserInfo getModifiedByUser() {
        return this.modifiedByUser;
    }

    public ZonedDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public ContentInfo getContent() {
        return this.content;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public Map<String, Map<String, String>> getLocalizedProperties() {
        return this.localizedProperties;
    }

    public Set<String> getAspectNames() {
        return this.aspectNames;
    }

    public String getPrimaryAssocQName() {
        return this.primaryAssocQName;
    }

    public List<String> getSecondaryParents() {
        return this.secondaryParents;
    }

    public Builder toBuilder() {
        return NodeResourceUtils.getFilledBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeResource)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeResource that = (NodeResource)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.nodeType, that.nodeType) && Objects.equals(this.isFile, that.isFile) && Objects.equals(this.isFolder, that.isFolder) && Objects.equals(this.createdByUser, that.createdByUser) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.modifiedByUser, that.modifiedByUser) && Objects.equals(this.modifiedAt, that.modifiedAt) && Objects.equals(this.content, that.content) && Objects.equals(this.properties, that.properties) && Objects.equals(this.localizedProperties, that.localizedProperties) && Objects.equals(this.aspectNames, that.aspectNames) && Objects.equals(this.secondaryParents, that.secondaryParents);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.nodeType, this.isFile, this.isFolder, this.createdByUser, this.createdAt, this.modifiedByUser, this.modifiedAt, this.content, this.properties, this.localizedProperties, this.aspectNames, this.primaryAssocQName, this.secondaryParents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(500);
        sb.append("NodeResource [id=").append(this.id).append(", name=").append(this.name).append(", nodeType=").append(this.nodeType).append(", isFile=").append(this.isFile).append(", isFolder=").append(this.isFolder).append(", createdByUser=").append(this.createdByUser).append(", createdAt=").append(this.createdAt).append(", modifiedByUser=").append(this.modifiedByUser).append(", modifiedAt=").append(this.modifiedAt).append(", content=").append(this.content).append(", properties=").append(this.properties).append(", localizedProperties=").append(this.localizedProperties).append(", aspectNames=").append(this.aspectNames).append(", primaryHierarchy=").append(this.primaryHierarchy).append(", primaryAssocQName=").append(this.primaryAssocQName).append(", secondaryParents=").append(this.secondaryParents).append(']');
        return sb.toString();
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        private String id;
        private String name;
        private String nodeType;
        private Boolean isFile;
        private Boolean isFolder;
        private UserInfo createdByUser;
        private ZonedDateTime createdAt;
        private UserInfo modifiedByUser;
        private ZonedDateTime modifiedAt;
        private List<String> primaryHierarchy;
        private ContentInfo content;
        private Map<String, Serializable> properties;
        private Map<String, Map<String, String>> localizedProperties;
        private Set<String> aspectNames;
        private String primaryAssocQName;
        private List<String> secondaryParents;

        public Builder() {
        }

        public Builder(Builder that) {
            this.id = that.id;
            this.name = that.name;
            this.nodeType = that.nodeType;
            this.isFile = that.isFile;
            this.isFolder = that.isFolder;
            this.createdByUser = that.createdByUser;
            this.createdAt = that.createdAt;
            this.modifiedByUser = that.modifiedByUser;
            this.modifiedAt = that.modifiedAt;
            this.content = that.content;
            this.primaryHierarchy = that.primaryHierarchy;
            this.properties = that.properties;
            this.localizedProperties = that.localizedProperties;
            this.aspectNames = that.aspectNames;
            this.primaryAssocQName = that.primaryAssocQName;
            this.secondaryParents = that.secondaryParents;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setNodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder setIsFile(Boolean isFile) {
            this.isFile = isFile;
            return this;
        }

        public Builder setIsFolder(Boolean isFolder) {
            this.isFolder = isFolder;
            return this;
        }

        public Builder setCreatedByUser(UserInfo createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public Builder setCreatedAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setModifiedByUser(UserInfo modifiedByUser) {
            this.modifiedByUser = modifiedByUser;
            return this;
        }

        public Builder setModifiedAt(ZonedDateTime modifiedAt) {
            this.modifiedAt = modifiedAt;
            return this;
        }

        public Builder setPrimaryHierarchy(List<String> primaryHierarchy) {
            this.primaryHierarchy = primaryHierarchy;
            return this;
        }

        public Builder setContent(ContentInfo content) {
            this.content = content;
            return this;
        }

        public Builder setProperties(Map<String, Serializable> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setLocalizedProperties(Map<String, Map<String, String>> localizedProperties) {
            this.localizedProperties = localizedProperties;
            return this;
        }

        public Builder setAspectNames(Set<String> aspectNames) {
            this.aspectNames = aspectNames;
            return this;
        }

        public Builder setPrimaryAssocQName(String primaryAssocQName) {
            this.primaryAssocQName = primaryAssocQName;
            return this;
        }

        public Builder setSecondaryParents(List<String> secondaryParents) {
            this.secondaryParents = secondaryParents == null ? Collections.emptyList() : secondaryParents;
            return this;
        }

        public NodeResource build() {
            return new NodeResource(this);
        }
    }
}

