/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.form.handler;

import feign.CollectionFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import java.util.List;
import org.alfresco.activiti.form.model.FormExceptionRepresentation;
import org.alfresco.activiti.form.model.InlineResponse400;
import org.alfresco.activiti.form.model.NamedObject;
import org.alfresco.activiti.form.model.SaveFormRepresentation;
import org.alfresco.activiti.form.model.SubmitFormRepresentation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="Forms", description="the Forms API")
public interface FormsApi {
    @ApiOperation(value="Get form definition latest version", nickname="getFormDefinition", notes="", response=String.class, tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ResponseEntity> getFormDefinition(@ApiParam(value="The id of the form definition", required=true) @PathVariable(value="formId") String var1);

    @ApiOperation(value="Get form definition by version", nickname="getFormDefinition_0", notes="", response=String.class, tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}/versions/{version}"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ResponseEntity> getFormDefinition_0(@ApiParam(value="The id of the form definition", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="", required=true) @PathVariable(value="version") Integer var2);

    @ApiOperation(value="Get form definitions summary", nickname="getFormDefinitions", notes="", response=String.class, tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms"}, produces={"application/json"}, method={RequestMethod.GET})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ResponseEntity> getFormDefinitions();

    @ApiOperation(value="Get form definition by version", nickname="getFormFieldValue", notes="", response=NamedObject.class, responseContainer="List", tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=NamedObject.class, responseContainer="List"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}/values/{formFieldId}"}, produces={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<List<NamedObject>> getFormFieldValue(@ApiParam(value="The id of the form definition", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="The id of the form field", required=true) @PathVariable(value="formFieldId") String var2);

    @ApiOperation(value="Save runtime forms", nickname="saveForm", notes="", tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}/save"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<Void> saveForm(@ApiParam(value="The id of the form instance to be saved", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="", required=true) @Valid @RequestBody SaveFormRepresentation var2);

    @ApiOperation(value="Submit forms latest version", nickname="submitForm", notes="", response=String.class, tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}/submit"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ResponseEntity> submitForm(@ApiParam(value="The id of the form to be submitted", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="", required=true) @Valid @RequestBody SubmitFormRepresentation var2);

    @ApiOperation(value="Submit forms specific version", nickname="submitForm_0", notes="", response=String.class, tags={"FORMS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/forms/{formId}/submit/versions/{version}"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<ResponseEntity> submitForm_0(@ApiParam(value="The id of the form to be submitted", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="", required=true) @PathVariable(value="version") Integer var2, @ApiParam(value="", required=true) @Valid @RequestBody SubmitFormRepresentation var3);
}

