/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.activiti.form.handler;

import feign.CollectionFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import jakarta.validation.Valid;
import org.alfresco.activiti.form.model.FormExceptionRepresentation;
import org.alfresco.activiti.form.model.InlineResponse400;
import org.alfresco.activiti.form.model.NamedEventBody;
import org.alfresco.activiti.form.model.SubmitFormRepresentation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="UserActions", description="the UserActions API")
public interface UserActionsApi {
    @ApiOperation(value="Send a named event", nickname="sendNamedEvent", notes="", response=String.class, tags={"USER_ACTIONS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/user-action/event/{uiName}/{eventName}/send"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> sendNamedEvent(@ApiParam(value="The name of the UI producing the event", required=true) @PathVariable(value="uiName") String var1, @ApiParam(value="The name of the event to send", required=true) @PathVariable(value="eventName") String var2, @ApiParam(value="") @Valid @RequestBody NamedEventBody var3);

    @ApiOperation(value="Submit forms latest version", nickname="submitForm", notes="", response=String.class, tags={"USER_ACTIONS"})
    @ApiResponses(value={@ApiResponse(code=400, message="Bad Request", response=InlineResponse400.class), @ApiResponse(code=404, message="Not Found", response=FormExceptionRepresentation.class), @ApiResponse(code=500, message="Internal Server Error", response=FormExceptionRepresentation.class), @ApiResponse(code=200, message="OK", response=String.class), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=403, message="Forbidden")})
    @RequestMapping(value={"/v1/user-action/form/{formId}/submit"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    @org.springframework.cloud.openfeign.CollectionFormat(value=CollectionFormat.CSV)
    public ResponseEntity<String> submitForm(@ApiParam(value="The id of the form to be submitted", required=true) @PathVariable(value="formId") String var1, @ApiParam(value="", required=true) @Valid @RequestBody SubmitFormRepresentation var2);
}

