/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.transform;

import jakarta.jms.Destination;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.alfresco.transform.base.fs.FileManager;
import org.alfresco.transform.base.messaging.TransformReplySender;
import org.alfresco.transform.base.model.FileRefResponse;
import org.alfresco.transform.base.probes.ProbeTransform;
import org.alfresco.transform.base.registry.CustomTransformers;
import org.alfresco.transform.base.sfs.SharedFileStoreClient;
import org.alfresco.transform.base.transform.ProcessHandler;
import org.alfresco.transform.base.transform.TransformManagerImpl;
import org.alfresco.transform.client.model.InternalContext;
import org.alfresco.transform.client.model.TransformReply;
import org.alfresco.transform.client.model.TransformRequest;
import org.alfresco.transform.common.ExtensionService;
import org.alfresco.transform.common.TransformerDebug;
import org.alfresco.transform.exceptions.TransformException;
import org.alfresco.transform.messages.TransformRequestValidator;
import org.alfresco.transform.messages.TransformStack;
import org.alfresco.transform.registry.TransformServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.multipart.MultipartFile;

@Component
public class TransformHandler {
    private static final Logger logger = LoggerFactory.getLogger(TransformHandler.class);
    private static final String FAILED_WRITING_TO_SFS = "Failed writing to SFS";
    @Autowired(required=false)
    private CustomTransformers customTransformers;
    @Autowired
    private SharedFileStoreClient alfrescoSharedFileStoreClient;
    @Autowired
    private TransformRequestValidator transformRequestValidator;
    @Autowired
    private TransformServiceRegistry transformRegistry;
    @Autowired
    private TransformReplySender transformReplySender;
    @Autowired
    private TransformerDebug transformerDebug;
    private final AtomicInteger httpRequestCount = new AtomicInteger(1);

    public ResponseEntity<Resource> handleHttpRequest(final HttpServletRequest request, final MultipartFile sourceMultipartFile, String sourceMimetype, String targetMimetype, final Map<String, String> requestParameters, ProbeTransform probeTransform) {
        final AtomicReference responseEntity = new AtomicReference();
        new ProcessHandler(sourceMimetype, targetMimetype, requestParameters, "e" + this.httpRequestCount.getAndIncrement(), this.transformRegistry, this.transformerDebug, probeTransform, this.customTransformers){

            @Override
            protected void init() throws IOException {
                this.transformManager.setRequest(request);
                this.transformManager.setTargetFile(FileManager.createTargetFile(request, this.sourceMimetype, this.targetMimetype));
                this.transformManager.keepTargetFile();
                super.init();
            }

            @Override
            protected InputStream getInputStream() {
                return TransformHandler.this.getInputStreamForHandleHttpRequest(requestParameters, sourceMultipartFile);
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                return TransformHandler.this.getOutputStreamFromFile(this.transformManager.getTargetFile());
            }

            @Override
            protected long getSourceSize() {
                return sourceMultipartFile == null ? -1L : sourceMultipartFile.getSize();
            }

            @Override
            protected void sendTransformResponse(TransformManagerImpl transformManager) {
                String extension = ExtensionService.getExtensionForTargetMimetype((String)this.targetMimetype, (String)this.sourceMimetype);
                responseEntity.set(FileManager.createAttachment("transform." + extension, transformManager.getTargetFile()));
            }
        }.handleTransformRequest();
        return (ResponseEntity)responseEntity.get();
    }

    public void handleProbeRequest(String sourceMimetype, String targetMimetype, Map<String, String> transformOptions, final File sourceFile, final File targetFile, ProbeTransform probeTransform) {
        new ProcessHandler(sourceMimetype, targetMimetype, transformOptions, "p" + this.httpRequestCount.getAndIncrement(), this.transformRegistry, this.transformerDebug, probeTransform, this.customTransformers){

            @Override
            protected void init() throws IOException {
                this.transformManager.setSourceFile(sourceFile);
                this.transformManager.setTargetFile(targetFile);
                this.transformManager.keepTargetFile();
                super.init();
            }

            @Override
            protected InputStream getInputStream() {
                return TransformHandler.this.getInputStreamForHandleProbeRequest(sourceFile);
            }

            @Override
            protected long getSourceSize() {
                return sourceFile.length();
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                return TransformHandler.this.getOutputStreamFromFile(targetFile);
            }
        }.handleTransformRequest();
    }

    public TransformReply handleMessageRequest(final TransformRequest request, final Long timeout, final Destination replyToQueue, ProbeTransform probeTransform) {
        final TransformReply reply = this.createBasicTransformReply(request);
        new ProcessHandler(request.getSourceMediaType(), request.getTargetMediaType(), request.getTransformRequestOptions(), "unset", this.transformRegistry, this.transformerDebug, probeTransform, this.customTransformers){

            @Override
            protected void init() throws IOException {
                TransformHandler.this.checkTransformRequestValid(request, reply);
                this.reference = TransformStack.getReference((InternalContext)reply.getInternalContext());
                this.initTarget();
                super.init();
            }

            @Override
            protected void initTarget() {
                this.transformManager.setTargetFile(FileManager.createTargetFile(null, this.sourceMimetype, this.targetMimetype));
            }

            @Override
            protected InputStream getInputStream() {
                return TransformHandler.this.getInputStreamForHandleMessageRequest(request);
            }

            @Override
            protected long getSourceSize() {
                return request.getSourceSize();
            }

            @Override
            protected OutputStream getOutputStream() throws IOException {
                return TransformHandler.this.getOutputStreamFromFile(this.transformManager.getTargetFile());
            }

            @Override
            protected void sendTransformResponse(TransformManagerImpl transformManager) {
                reply.getInternalContext().setCurrentSourceSize(transformManager.getOutputLength());
                TransformHandler.this.saveTargetFileInSharedFileStore(transformManager.getTargetFile(), reply);
                TransformHandler.this.sendSuccessfulResponse(timeout, reply, replyToQueue);
            }

            @Override
            protected void handleTransformException(TransformException e) {
                TransformHandler.this.sendFailedResponse(reply, (Exception)((Object)e), e.getStatus(), replyToQueue);
            }

            @Override
            protected void handleException(Exception e) {
                TransformHandler.this.sendFailedResponse(reply, e, HttpStatus.INTERNAL_SERVER_ERROR, replyToQueue);
            }
        }.handleTransformRequest();
        return reply;
    }

    private void sendSuccessfulResponse(Long timeout, TransformReply reply, Destination replyToQueue) {
        logger.trace("Sending successful {}, timeout {} ms", (Object)reply, (Object)timeout);
        this.transformReplySender.send(replyToQueue, reply);
    }

    private void sendFailedResponse(TransformReply reply, Exception e, HttpStatus status, Destination replyToQueue) {
        reply.setStatus(status.value());
        reply.setErrorDetails(TransformHandler.messageWithCause("Transform failed", e));
        this.transformerDebug.logFailure(reply);
        logger.trace("Transform failed. Sending {}", (Object)reply, (Object)e);
        this.transformReplySender.send(replyToQueue, reply);
    }

    private void checkTransformRequestValid(TransformRequest request, TransformReply reply) {
        Errors errors = this.validateTransformRequest(request);
        this.validateInternalContext(request, errors);
        reply.setInternalContext(request.getInternalContext());
        if (!errors.getAllErrors().isEmpty()) {
            String errorDetails = errors.getAllErrors().stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new TransformException(HttpStatus.BAD_REQUEST, errorDetails);
        }
    }

    private TransformReply createBasicTransformReply(TransformRequest request) {
        TransformReply reply = new TransformReply();
        reply.setRequestId(request.getRequestId());
        reply.setSourceReference(request.getSourceReference());
        reply.setSchema(request.getSchema());
        reply.setClientData(request.getClientData());
        reply.setInternalContext(request.getInternalContext());
        return reply;
    }

    private Errors validateTransformRequest(TransformRequest transformRequest) {
        DirectFieldBindingResult errors = new DirectFieldBindingResult((Object)transformRequest, "request");
        this.transformRequestValidator.validate((Object)transformRequest, (Errors)errors);
        return errors;
    }

    private void validateInternalContext(TransformRequest request, Errors errors) {
        String errorMessage = InternalContext.checkForBasicErrors((InternalContext)request.getInternalContext(), (String)"T-Request");
        if (errorMessage != null) {
            errors.rejectValue("internalContext", null, errorMessage);
        }
        this.initialiseContext(request);
    }

    private void initialiseContext(TransformRequest request) {
        request.setInternalContext(InternalContext.initialise((InternalContext)request.getInternalContext()));
    }

    private InputStream getSharedFileStoreInputStream(String sourceReference) {
        ResponseEntity<Resource> responseEntity = this.alfrescoSharedFileStoreClient.retrieveFile(sourceReference);
        Resource body = (Resource)responseEntity.getBody();
        if (body == null) {
            String message = "Source file with reference: " + sourceReference + " is null or empty.";
            logger.warn(message);
            throw new TransformException(HttpStatus.BAD_REQUEST, message);
        }
        try {
            return body.getInputStream();
        }
        catch (IOException e) {
            String message = "Shared File Store reference is invalid.";
            logger.warn(message);
            throw new TransformException(HttpStatus.BAD_REQUEST, message, (Throwable)e);
        }
    }

    private InputStream getInputStreamForHandleHttpRequest(Map<String, String> requestParameters, MultipartFile sourceMultipartFile) {
        String directUrl = requestParameters.getOrDefault("directAccessUrl", "");
        return new BufferedInputStream(directUrl.isBlank() ? FileManager.getMultipartFileInputStream(sourceMultipartFile) : FileManager.getDirectAccessUrlInputStream(directUrl));
    }

    private InputStream getInputStreamForHandleProbeRequest(File sourceFile) {
        try {
            return new BufferedInputStream(new FileInputStream(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, TransformHandler.messageWithCause("Failed to read the probe source", e));
        }
    }

    private InputStream getInputStreamForHandleMessageRequest(TransformRequest request) {
        String directUrl = request.getTransformRequestOptions().getOrDefault("directAccessUrl", "");
        try {
            return new BufferedInputStream(directUrl.isBlank() ? this.getSharedFileStoreInputStream(request.getSourceReference()) : FileManager.getDirectAccessUrlInputStream(directUrl));
        }
        catch (TransformException e) {
            throw new TransformException(e.getStatus(), TransformHandler.messageWithCause("Failed to read the source", e));
        }
        catch (HttpClientErrorException e) {
            throw new TransformException(HttpStatus.resolve((int)e.getStatusCode().value()), TransformHandler.messageWithCause("Failed to read the source from the SFS", e));
        }
    }

    private OutputStream getOutputStreamFromFile(File targetFile) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(targetFile));
    }

    private void saveTargetFileInSharedFileStore(File targetFile, TransformReply reply) {
        FileRefResponse targetRef;
        try {
            targetRef = this.alfrescoSharedFileStoreClient.saveFile(targetFile);
        }
        catch (TransformException e) {
            throw new TransformException(e.getStatus(), TransformHandler.messageWithCause(FAILED_WRITING_TO_SFS, e));
        }
        catch (HttpClientErrorException e) {
            throw new TransformException(HttpStatus.resolve((int)e.getStatusCode().value()), TransformHandler.messageWithCause(FAILED_WRITING_TO_SFS, e));
        }
        catch (Exception e) {
            throw new TransformException(HttpStatus.INTERNAL_SERVER_ERROR, TransformHandler.messageWithCause(FAILED_WRITING_TO_SFS, e));
        }
        reply.setTargetReference(targetRef.getEntry().getFileRef());
        reply.setStatus(HttpStatus.CREATED.value());
    }

    private static String messageWithCause(String prefix, Throwable e) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(" - ");
        if (e.getClass() != TransformException.class) {
            sb.append(e.getClass().getSimpleName()).append(": ");
        }
        sb.append(e.getMessage());
        while (e.getCause() != null) {
            e = e.getCause();
            sb.append(", cause ").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage());
        }
        return sb.toString();
    }
}

