/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.transform.base.html;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.transform.config.TransformOption;
import org.alfresco.transform.config.TransformOptionGroup;
import org.alfresco.transform.config.TransformOptionValue;
import org.springframework.stereotype.Component;

@Component
public class OptionsHelper {
    private OptionsHelper() {
    }

    public static Set<String> getOptionNames(Map<String, Set<TransformOption>> transformOptionsByName) {
        TreeSet<String> set = new TreeSet<String>();
        transformOptionsByName.forEach((optionName, optionSet) -> optionSet.stream().forEach(option -> OptionsHelper.addOption(set, option)));
        return set;
    }

    private static void addOption(Set<String> set, TransformOption option) {
        if (option instanceof TransformOptionGroup) {
            OptionsHelper.addGroup(set, (TransformOptionGroup)option);
        } else {
            OptionsHelper.addValue(set, (TransformOptionValue)option);
        }
    }

    private static void addGroup(Set<String> set, TransformOptionGroup group) {
        group.getTransformOptions().stream().forEach(option -> OptionsHelper.addOption(set, option));
    }

    private static void addValue(Set<String> set, TransformOptionValue value) {
        set.add(value.getName());
    }
}

