/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

import org.alfresco.api.AlfrescoPublicApi;

@AlfrescoPublicApi
public enum AuthorityType {
    ADMIN{

        @Override
        public boolean isFixedString() {
            return true;
        }

        @Override
        public String getFixedString() {
            return "ROLE_ADMINISTRATOR";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 0;
        }
    }
    ,
    EVERYONE{

        @Override
        public boolean isFixedString() {
            return true;
        }

        @Override
        public String getFixedString() {
            return "GROUP_EVERYONE";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 1;
        }
    }
    ,
    OWNER{

        @Override
        public boolean isFixedString() {
            return true;
        }

        @Override
        public String getFixedString() {
            return "ROLE_OWNER";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 2;
        }
    }
    ,
    GUEST{

        @Override
        public boolean isFixedString() {
            return true;
        }

        @Override
        public String getFixedString() {
            return "ROLE_GUEST";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 3;
        }
    }
    ,
    GROUP{

        @Override
        public boolean isFixedString() {
            return false;
        }

        @Override
        public String getFixedString() {
            return "";
        }

        @Override
        public boolean isPrefixed() {
            return true;
        }

        @Override
        public String getPrefixString() {
            return "GROUP_";
        }

        @Override
        public int getOrderPosition() {
            return 4;
        }
    }
    ,
    ROLE{

        @Override
        public boolean isFixedString() {
            return false;
        }

        @Override
        public String getFixedString() {
            return "";
        }

        @Override
        public boolean isPrefixed() {
            return true;
        }

        @Override
        public String getPrefixString() {
            return "ROLE_";
        }

        @Override
        public int getOrderPosition() {
            return 5;
        }
    }
    ,
    USER{

        @Override
        public boolean isFixedString() {
            return false;
        }

        @Override
        public String getFixedString() {
            return "";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 6;
        }
    }
    ,
    WILDCARD{

        @Override
        public boolean isFixedString() {
            return false;
        }

        @Override
        public String getFixedString() {
            return "";
        }

        @Override
        public boolean isPrefixed() {
            return false;
        }

        @Override
        public String getPrefixString() {
            return "";
        }

        @Override
        public int getOrderPosition() {
            return 7;
        }
    };


    public abstract boolean isFixedString();

    public abstract String getFixedString();

    public abstract boolean isPrefixed();

    public abstract String getPrefixString();

    public abstract int getOrderPosition();

    public boolean equals(String authority) {
        return this.equals((Object)AuthorityType.getAuthorityType(authority));
    }

    public static AuthorityType getAuthorityType(String authority) {
        AuthorityType authorityType;
        if (null == authority) {
            authorityType = WILDCARD;
        } else {
            if (authority.equals("ROLE_ADMINISTRATOR")) {
                authorityType = ADMIN;
            }
            authorityType = authority.equals("GROUP_EVERYONE") ? EVERYONE : (authority.equals("ROLE_OWNER") ? OWNER : (authority.equalsIgnoreCase("ROLE_GUEST") ? GUEST : (authority.startsWith("GROUP_") ? GROUP : (authority.startsWith("ROLE_") ? ROLE : USER))));
        }
        return authorityType;
    }
}

