/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.CompiledModelsCache;
import org.alfresco.repo.dictionary.CoreDictionaryRegistryImpl;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryRegistry;
import org.alfresco.repo.dictionary.M2AnonymousTypeDefinition;
import org.alfresco.repo.dictionary.M2ClassDefinition;
import org.alfresco.repo.dictionary.M2ConstraintDefinition;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2ModelDiff;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.M2NamespaceDefinition;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.repo.dictionary.TenantDictionaryRegistryImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.ConstraintDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.alfresco.service.cmr.dictionary.NamespaceDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class DictionaryDAOImpl
implements DictionaryDAO,
NamespaceDAO,
ApplicationListener<ApplicationEvent> {
    private TenantService tenantService;
    private ThreadLocal<Map<String, DictionaryRegistry>> dictionaryRegistryThreadLocal = new ThreadLocal();
    private CompiledModelsCache dictionaryRegistryCache;
    private List<DictionaryListener> dictionaryListeners = new ArrayList<DictionaryListener>();
    private ReadWriteLock dictionaryListenersLock = new ReentrantReadWriteLock();
    private static Log logger = LogFactory.getLog(DictionaryDAO.class);
    private String defaultAnalyserResourceBundleName;
    private ClassLoader resourceClassLoader;
    private AtomicBoolean contextRefreshed = new AtomicBoolean(false);

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryRegistryCache(CompiledModelsCache dictionaryRegistryCache) {
        this.dictionaryRegistryCache = dictionaryRegistryCache;
    }

    @Override
    @Deprecated
    public void register(DictionaryListener dictionaryListener) {
        this.registerListener(dictionaryListener);
    }

    @Override
    public void registerListener(DictionaryListener dictionaryListener) {
        this.dictionaryListenersLock.writeLock().lock();
        try {
            if (!this.dictionaryListeners.contains(dictionaryListener)) {
                this.dictionaryListeners.add(dictionaryListener);
            }
        }
        finally {
            this.dictionaryListenersLock.writeLock().unlock();
        }
    }

    @Override
    public List<DictionaryListener> getDictionaryListeners() {
        this.dictionaryListenersLock.readLock().lock();
        try {
            ArrayList<DictionaryListener> arrayList = new ArrayList<DictionaryListener>(this.dictionaryListeners);
            return arrayList;
        }
        finally {
            this.dictionaryListenersLock.readLock().unlock();
        }
    }

    private Map<String, DictionaryRegistry> getThreadLocal() {
        Map<String, DictionaryRegistry> map = this.dictionaryRegistryThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, DictionaryRegistry>();
            this.dictionaryRegistryThreadLocal.set(map);
        }
        return map;
    }

    private DictionaryRegistry createCoreDictionaryRegistry() {
        CoreDictionaryRegistryImpl dictionaryRegistry = new CoreDictionaryRegistryImpl(this);
        return dictionaryRegistry;
    }

    private DictionaryRegistry createTenantDictionaryRegistry(final String tenant) {
        DictionaryRegistry result = AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<DictionaryRegistry>(){

            @Override
            public DictionaryRegistry doWork() {
                TenantDictionaryRegistryImpl dictionaryRegistry = new TenantDictionaryRegistryImpl(DictionaryDAOImpl.this, tenant);
                return dictionaryRegistry;
            }
        }, this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenant));
        return result;
    }

    @Override
    public void init() {
        String tenant = this.tenantService.getCurrentUserDomain();
        this.dictionaryRegistryCache.forceInChangesForThisUncommittedTransaction(tenant);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Triggered immediate reload of dictionary for tenant " + tenant));
        }
    }

    @Override
    public void destroy() {
        String tenant = this.tenantService.getCurrentUserDomain();
        this.dictionaryRegistryCache.remove(tenant);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dictionary destroyed for tenant " + tenant));
        }
    }

    @Override
    public void reset() {
        String tenant = this.tenantService.getCurrentUserDomain();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resetting dictionary for tenant " + tenant));
        }
        this.destroy();
        this.getDictionaryRegistry(tenant);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dictionary reset complete for tenant " + tenant));
        }
    }

    @Override
    public QName putModel(M2Model model) {
        QName ret = this.putModelImpl(model, true);
        return ret;
    }

    @Override
    public QName putModelIgnoringConstraints(M2Model model) {
        return this.putModelImpl(model, false);
    }

    private QName putModelImpl(M2Model model, boolean enableConstraintClassLoading) {
        CompiledModel compiledModel = model.compile(this, this, enableConstraintClassLoading);
        QName modelName = compiledModel.getModelDefinition().getName();
        this.getTenantDictionaryRegistry().putModel(compiledModel);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Registered core model: " + modelName.toPrefixString(this)));
            for (M2Namespace namespace : model.getNamespaces()) {
                logger.trace((Object)("Registered core namespace: '" + namespace.getUri() + "' (prefix '" + namespace.getPrefix() + "')"));
            }
        }
        return modelName;
    }

    @Override
    public void removeModel(QName modelName) {
        this.getTenantDictionaryRegistry().removeModel(modelName);
    }

    private DictionaryRegistry getTenantDictionaryRegistry() {
        String tenantDomain = this.tenantService.getCurrentUserDomain();
        return this.getDictionaryRegistry(tenantDomain);
    }

    public CompiledModel getCompiledModel(QName modelName) {
        return this.getTenantDictionaryRegistry().getModel(modelName);
    }

    @Override
    public DataTypeDefinition getDataType(QName typeName) {
        DataTypeDefinition dataTypeDef = null;
        if (typeName != null) {
            dataTypeDef = this.getTenantDictionaryRegistry().getDataType(typeName);
        }
        return dataTypeDef;
    }

    @Override
    public DataTypeDefinition getDataType(Class javaClass) {
        return this.getTenantDictionaryRegistry().getDataType(javaClass);
    }

    @Override
    public Collection<DataTypeDefinition> getDataTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getDataTypes();
    }

    @Override
    public TypeDefinition getType(QName typeName) {
        TypeDefinition typeDef = null;
        if (typeName != null) {
            typeDef = this.getTenantDictionaryRegistry().getType(typeName);
        }
        return typeDef;
    }

    @Override
    public Collection<QName> getSubTypes(QName superType, boolean follow) {
        HashMap<QName, QName> allTypesAndParents = new HashMap<QName, QName>();
        for (CompiledModel model : this.getCompiledModels(true).values()) {
            for (TypeDefinition type : model.getTypes()) {
                allTypesAndParents.put(type.getName(), type.getParentName());
            }
        }
        HashSet<QName> subTypes = new HashSet<QName>();
        for (QName type : allTypesAndParents.keySet()) {
            if (follow) {
                QName current = type;
                while (current != null && !current.equals(superType)) {
                    current = (QName)allTypesAndParents.get(current);
                }
                if (current == null) continue;
                subTypes.add(type);
                continue;
            }
            QName typesSuperType = (QName)allTypesAndParents.get(type);
            if (typesSuperType == null || !typesSuperType.equals(superType)) continue;
            subTypes.add(type);
        }
        return subTypes;
    }

    @Override
    public AspectDefinition getAspect(QName aspectName) {
        AspectDefinition aspectDef = null;
        if (aspectName != null) {
            aspectDef = this.getTenantDictionaryRegistry().getAspect(aspectName);
        }
        return aspectDef;
    }

    @Override
    public Collection<QName> getSubAspects(QName superAspect, boolean follow) {
        HashMap<QName, QName> allAspectsAndParents = new HashMap<QName, QName>();
        for (CompiledModel model : this.getCompiledModels(true).values()) {
            for (AspectDefinition aspect : model.getAspects()) {
                allAspectsAndParents.put(aspect.getName(), aspect.getParentName());
            }
        }
        HashSet<QName> subAspects = new HashSet<QName>();
        for (QName aspect : allAspectsAndParents.keySet()) {
            if (follow) {
                QName current = aspect;
                while (current != null && !current.equals(superAspect)) {
                    current = (QName)allAspectsAndParents.get(current);
                }
                if (current == null) continue;
                subAspects.add(aspect);
                continue;
            }
            QName typesSuperAspect = (QName)allAspectsAndParents.get(aspect);
            if (typesSuperAspect == null || !typesSuperAspect.equals(superAspect)) continue;
            subAspects.add(aspect);
        }
        return subAspects;
    }

    @Override
    public ClassDefinition getClass(QName className) {
        ClassDefinition classDef = null;
        if (className != null) {
            classDef = this.getTenantDictionaryRegistry().getClass(className);
        }
        return classDef;
    }

    @Override
    public PropertyDefinition getProperty(QName propertyName) {
        PropertyDefinition propertyDef = null;
        if (propertyName != null) {
            propertyDef = this.getTenantDictionaryRegistry().getProperty(propertyName);
        }
        return propertyDef;
    }

    @Override
    public ConstraintDefinition getConstraint(QName constraintQName) {
        ConstraintDefinition constraintDef = null;
        if (constraintQName != null) {
            constraintDef = this.getTenantDictionaryRegistry().getConstraint(constraintQName);
        }
        return constraintDef;
    }

    @Override
    public AssociationDefinition getAssociation(QName assocName) {
        return this.getTenantDictionaryRegistry().getAssociation(assocName);
    }

    @Override
    public Collection<AssociationDefinition> getAssociations(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getAssociations();
    }

    @Override
    public Collection<QName> getModels(boolean includeInherited) {
        return this.getCompiledModels(includeInherited).keySet();
    }

    @Override
    public Collection<QName> getModels() {
        return this.getModels(true);
    }

    @Override
    public Collection<QName> getTypes(boolean includeInherited) {
        return this.getTenantDictionaryRegistry().getTypes(includeInherited);
    }

    @Override
    public Collection<QName> getAssociations(boolean includeInherited) {
        return this.getTenantDictionaryRegistry().getAssociations(includeInherited);
    }

    @Override
    public Collection<QName> getAspects(boolean includeInherited) {
        return this.getTenantDictionaryRegistry().getAspects(includeInherited);
    }

    @Override
    public boolean isModelInherited(QName modelName) {
        return this.getTenantDictionaryRegistry().isModelInherited(modelName);
    }

    private Map<QName, CompiledModel> getCompiledModels(boolean includeInherited) {
        return this.getTenantDictionaryRegistry().getCompiledModels(includeInherited);
    }

    @Override
    public ModelDefinition getModel(QName name) {
        CompiledModel model = this.getCompiledModel(name);
        return model.getModelDefinition();
    }

    @Override
    public Collection<TypeDefinition> getTypes(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getTypes();
    }

    @Override
    public Collection<AspectDefinition> getAspects(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getAspects();
    }

    @Override
    public TypeDefinition getAnonymousType(QName type, Collection<QName> aspects) {
        TypeDefinition typeDef = this.getType(type);
        if (typeDef == null) {
            throw new DictionaryException("d_dictionary.model.err.type_not_found", type);
        }
        ArrayList<AspectDefinition> aspectDefs = new ArrayList<AspectDefinition>();
        if (aspects != null) {
            for (QName aspect : aspects) {
                AspectDefinition aspectDef = this.getAspect(aspect);
                if (aspectDef == null) {
                    throw new DictionaryException("d_dictionary.model.err.aspect_not_found", aspect);
                }
                aspectDefs.add(aspectDef);
            }
        }
        return new M2AnonymousTypeDefinition(typeDef, aspectDefs);
    }

    @Override
    public Collection<PropertyDefinition> getProperties(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        return model.getProperties();
    }

    @Override
    public Collection<PropertyDefinition> getProperties(QName modelName, QName dataType) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        Collection<PropertyDefinition> props = this.getProperties(modelName);
        for (PropertyDefinition prop : props) {
            if (dataType != null && !prop.getDataType().getName().equals(dataType)) continue;
            properties.add(prop);
        }
        return properties;
    }

    @Override
    public Collection<PropertyDefinition> getPropertiesOfDataType(QName dataType) {
        HashSet<PropertyDefinition> properties = new HashSet<PropertyDefinition>();
        Collection<QName> modelNames = this.getModels();
        for (QName modelName : modelNames) {
            properties.addAll(this.getProperties(modelName, dataType));
        }
        return properties;
    }

    @Override
    public Collection<NamespaceDefinition> getNamespaces(QName modelName) {
        CompiledModel model = this.getCompiledModel(modelName);
        ModelDefinition modelDef = model.getModelDefinition();
        return modelDef.getNamespaces();
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName modelName) {
        return this.getConstraints(modelName, false);
    }

    @Override
    public Collection<ConstraintDefinition> getConstraints(QName modelName, boolean referenceableDefsOnly) {
        CompiledModel model = this.getCompiledModel(modelName);
        if (referenceableDefsOnly) {
            return this.getReferenceableConstraintDefs(model);
        }
        return model.getConstraints();
    }

    private Collection<ConstraintDefinition> getReferenceableConstraintDefs(CompiledModel model) {
        Collection<ConstraintDefinition> conDefs = model.getConstraints();
        Collection<PropertyDefinition> propDefs = model.getProperties();
        for (PropertyDefinition propDef : propDefs) {
            for (ConstraintDefinition conDef : propDef.getConstraints()) {
                conDefs.remove(conDef);
            }
        }
        return conDefs;
    }

    @Override
    public DictionaryRegistry getDictionaryRegistry(String tenantDomain) {
        DictionaryRegistry dictionaryRegistry = null;
        if (tenantDomain == null) {
            throw new AlfrescoRuntimeException("Tenant must be set");
        }
        dictionaryRegistry = this.getThreadLocal().get(tenantDomain);
        if (dictionaryRegistry == null) {
            dictionaryRegistry = (DictionaryRegistry)this.dictionaryRegistryCache.get(tenantDomain);
        }
        return dictionaryRegistry;
    }

    public DictionaryRegistry initDictionaryRegistry(final String tenantDomain) {
        return AuthenticationUtil.runAs(new AuthenticationUtil.RunAsWork<DictionaryRegistry>(){

            @Override
            public DictionaryRegistry doWork() {
                DictionaryRegistry dictionaryRegistry = null;
                dictionaryRegistry = tenantDomain.equals("") ? DictionaryDAOImpl.this.createCoreDictionaryRegistry() : DictionaryDAOImpl.this.createTenantDictionaryRegistry(tenantDomain);
                DictionaryDAOImpl.this.getThreadLocal().put(tenantDomain, dictionaryRegistry);
                dictionaryRegistry.init();
                DictionaryDAOImpl.this.getThreadLocal().remove(tenantDomain);
                return dictionaryRegistry;
            }
        }, this.tenantService.getDomainUser(AuthenticationUtil.getSystemUserName(), tenantDomain));
    }

    @Override
    public List<M2ModelDiff> diffModel(M2Model model) {
        return this.diffModel(model, true);
    }

    @Override
    public List<M2ModelDiff> diffModelIgnoringConstraints(M2Model model) {
        return this.diffModel(model, false);
    }

    public List<M2ModelDiff> diffModel(M2Model model, boolean enableConstraintClassLoading) {
        CompiledModel compiledModel = model.compile(this, this, enableConstraintClassLoading);
        QName modelName = compiledModel.getModelDefinition().getName();
        CompiledModel previousVersion = null;
        try {
            previousVersion = this.getCompiledModel(modelName);
        }
        catch (DictionaryException e) {
            logger.debug((Object)e);
        }
        if (previousVersion == null) {
            return new ArrayList<M2ModelDiff>(0);
        }
        return this.diffModel(previousVersion, compiledModel);
    }

    List<M2ModelDiff> diffModel(CompiledModel previousVersion, CompiledModel model) {
        ArrayList<M2ModelDiff> M2ModelDiffs;
        block20: {
            block19: {
                M2ModelDiffs = new ArrayList<M2ModelDiff>();
                if (previousVersion == null) break block19;
                Collection<TypeDefinition> previousTypes = previousVersion.getTypes();
                Collection<AspectDefinition> previousAspects = previousVersion.getAspects();
                Collection<ConstraintDefinition> previousConDefs = this.getReferenceableConstraintDefs(previousVersion);
                Collection<NamespaceDefinition> previousImportedNamespaces = previousVersion.getModelDefinition().getImportedNamespaces();
                if (model == null) {
                    for (TypeDefinition previousType : previousTypes) {
                        M2ModelDiffs.add(new M2ModelDiff(previousType.getName(), "TYPE", "deleted"));
                    }
                    for (AspectDefinition previousAspect : previousAspects) {
                        M2ModelDiffs.add(new M2ModelDiff(previousAspect.getName(), "ASPECT", "deleted"));
                    }
                    for (ConstraintDefinition previousConDef : previousConDefs) {
                        M2ModelDiffs.add(new M2ModelDiff(previousConDef.getName(), "TYPE_CONSTRAINT", "deleted"));
                    }
                } else {
                    Collection<TypeDefinition> types = model.getTypes();
                    Collection<AspectDefinition> aspects = model.getAspects();
                    Collection<ConstraintDefinition> conDefs = this.getReferenceableConstraintDefs(model);
                    Collection<NamespaceDefinition> importedNamespaces = model.getModelDefinition().getImportedNamespaces();
                    if (previousTypes.size() != 0) {
                        M2ModelDiffs.addAll(M2ClassDefinition.diffClassLists(new ArrayList<ClassDefinition>(previousTypes), new ArrayList<ClassDefinition>(types), "TYPE"));
                    } else {
                        for (TypeDefinition type : types) {
                            M2ModelDiffs.add(new M2ModelDiff(type.getName(), "TYPE", "created"));
                        }
                    }
                    if (previousAspects.size() != 0) {
                        M2ModelDiffs.addAll(M2ClassDefinition.diffClassLists(new ArrayList<ClassDefinition>(previousAspects), new ArrayList<ClassDefinition>(aspects), "ASPECT"));
                    } else {
                        for (AspectDefinition aspect : aspects) {
                            M2ModelDiffs.add(new M2ModelDiff(aspect.getName(), "ASPECT", "created"));
                        }
                    }
                    if (previousConDefs.size() != 0) {
                        M2ModelDiffs.addAll(M2ConstraintDefinition.diffConstraintLists(new ArrayList<ConstraintDefinition>(previousConDefs), new ArrayList<ConstraintDefinition>(conDefs)));
                    } else {
                        for (ConstraintDefinition conDef : conDefs) {
                            M2ModelDiffs.add(new M2ModelDiff(conDef.getName(), "TYPE_CONSTRAINT", "created"));
                        }
                    }
                    if (previousImportedNamespaces.size() != 0) {
                        M2ModelDiffs.addAll(M2NamespaceDefinition.diffNamespaceDefinitionLists(new ArrayList<NamespaceDefinition>(previousImportedNamespaces), new ArrayList<NamespaceDefinition>(importedNamespaces)));
                    } else {
                        for (NamespaceDefinition namespaceDefinition : importedNamespaces) {
                            M2ModelDiffs.add(new M2ModelDiff(namespaceDefinition.getModel().getName(), namespaceDefinition, "TYPE_NAMESPACE", "created"));
                        }
                    }
                }
                break block20;
            }
            if (model == null) break block20;
            Collection<TypeDefinition> types = model.getTypes();
            Collection<AspectDefinition> aspects = model.getAspects();
            for (TypeDefinition type : types) {
                M2ModelDiffs.add(new M2ModelDiff(type.getName(), "TYPE", "created"));
            }
            for (AspectDefinition aspect : aspects) {
                M2ModelDiffs.add(new M2ModelDiff(aspect.getName(), "ASPECT", "created"));
            }
        }
        return M2ModelDiffs;
    }

    @Override
    public ClassLoader getResourceClassLoader() {
        return this.resourceClassLoader;
    }

    @Override
    public void setResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourceClassLoader = resourceClassLoader;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.getTenantDictionaryRegistry().getNamespaceURI(prefix);
    }

    @Override
    public Collection<String> getPrefixes(String URI) {
        return this.getTenantDictionaryRegistry().getPrefixes(URI);
    }

    @Override
    public void addURI(String uri) {
        this.getTenantDictionaryRegistry().addURI(uri);
    }

    @Override
    public Collection<String> getPrefixes() {
        return Collections.unmodifiableCollection(this.getTenantDictionaryRegistry().getPrefixesCache().keySet());
    }

    @Override
    public Collection<String> getURIs() {
        return Collections.unmodifiableCollection(this.getTenantDictionaryRegistry().getUrisCache());
    }

    @Override
    public void removeURI(String uri) {
        this.getTenantDictionaryRegistry().removeURI(uri);
    }

    @Override
    public void addPrefix(String prefix, String uri) {
        this.getTenantDictionaryRegistry().addPrefix(prefix, uri);
    }

    @Override
    public void removePrefix(String prefix) {
        this.getTenantDictionaryRegistry().removePrefix(prefix);
    }

    @Override
    public boolean isContextRefreshed() {
        return this.contextRefreshed.get();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.contextRefreshed.set(true);
        }
    }
}

