/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.CMISPropertyLuceneBuilder;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.mapping.BaseTypeIdLuceneBuilder;
import org.alfresco.opencmis.mapping.ContentStreamLengthLuceneBuilder;
import org.alfresco.opencmis.mapping.ContentStreamMimetypeLuceneBuilder;
import org.alfresco.opencmis.mapping.DirectLuceneBuilder;
import org.alfresco.opencmis.mapping.FixedValueLuceneBuilder;
import org.alfresco.opencmis.mapping.NotSupportedLuceneBuilder;
import org.alfresco.opencmis.mapping.ObjectIdLuceneBuilder;
import org.alfresco.opencmis.mapping.ObjectTypeIdLuceneBuilder;
import org.alfresco.opencmis.mapping.ParentLuceneBuilder;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.InitializingBean;

public class RuntimePropertyLuceneBuilderMapping
implements PropertyLuceneBuilderMapping,
InitializingBean {
    private CMISDictionaryService cmisDictionaryService;
    private DictionaryService dictionaryService;
    private Map<String, CMISPropertyLuceneBuilder> luceneBuilders = new HashMap<String, CMISPropertyLuceneBuilder>();

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void afterPropertiesSet() {
        this.registerPropertyLuceneBuilder("cmis:objectId", new ObjectIdLuceneBuilder(this.dictionaryService));
        this.registerPropertyLuceneBuilder("cmis:objectTypeId", new ObjectTypeIdLuceneBuilder(this.cmisDictionaryService));
        this.registerPropertyLuceneBuilder("cmis:baseTypeId", new BaseTypeIdLuceneBuilder(this.cmisDictionaryService));
        this.registerPropertyLuceneBuilder("cmis:createdBy", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_CREATOR));
        this.registerPropertyLuceneBuilder("cmis:creationDate", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_CREATED));
        this.registerPropertyLuceneBuilder("cmis:lastModifiedBy", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_MODIFIER));
        this.registerPropertyLuceneBuilder("cmis:lastModificationDate", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_MODIFIED));
        this.registerPropertyLuceneBuilder("cmis:changeToken", new FixedValueLuceneBuilder(null));
        this.registerPropertyLuceneBuilder("cmis:name", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_NAME));
        this.registerPropertyLuceneBuilder("cmis:description", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_DESCRIPTION));
        this.registerPropertyLuceneBuilder("cmis:isImmutable", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:isLatestVersion", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:isMajorVersion", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:isLatestMajorVersion", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:versionLabel", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:versionSeriesId", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:isVersionSeriesCheckedOut", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:versionSeriesCheckedOutBy", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:versionSeriesCheckedOutId", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:checkinComment", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:contentStreamLength", new ContentStreamLengthLuceneBuilder(this.dictionaryService));
        this.registerPropertyLuceneBuilder("cmis:contentStreamMimeType", new ContentStreamMimetypeLuceneBuilder(this.dictionaryService));
        this.registerPropertyLuceneBuilder("cmis:contentStreamId", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:contentStreamFileName", new DirectLuceneBuilder(this.dictionaryService, ContentModel.PROP_NAME));
        this.registerPropertyLuceneBuilder("cmis:parentId", new ParentLuceneBuilder(this.dictionaryService));
        this.registerPropertyLuceneBuilder("cmis:path", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:allowedChildObjectTypeIds", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:sourceId", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("cmis:targetId", new NotSupportedLuceneBuilder());
        this.registerPropertyLuceneBuilder("alfcmis:nodeRef", new NotSupportedLuceneBuilder());
    }

    @Override
    public CMISPropertyLuceneBuilder getPropertyLuceneBuilder(String propertyId) {
        return this.luceneBuilders.get(propertyId);
    }

    @Override
    public CMISPropertyLuceneBuilder createDirectPropertyLuceneBuilder(QName propertyName) {
        return new DirectLuceneBuilder(this.dictionaryService, propertyName);
    }

    private void registerPropertyLuceneBuilder(String name, CMISPropertyLuceneBuilder luceneBuilder) {
        this.luceneBuilders.put(name, luceneBuilder);
    }
}

