/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.service.namespace.QName;

public class QNameCache {
    private final int maxSize;
    private final Map<QName, String> qNameToNameCache = new HashMap<QName, String>();
    private final Map<String, QName> nameToQNameCache = new HashMap<String, QName>();
    private final ReentrantReadWriteLock qNameToNameLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock qNameToNameWriteLock = this.qNameToNameLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock qNameToNameReadLock = this.qNameToNameLock.readLock();
    private final ReentrantReadWriteLock nameToQNameLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock nameToQNameWriteLock = this.nameToQNameLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock nameToQNameReadLock = this.nameToQNameLock.readLock();

    public QNameCache(int maxSize) {
        this.maxSize = maxSize;
    }

    public String getName(QName qName) {
        this.qNameToNameReadLock.lock();
        try {
            String string = this.qNameToNameCache.get(qName);
            return string;
        }
        finally {
            this.qNameToNameReadLock.unlock();
        }
    }

    public void putQNameToName(QName qName, String name) {
        this.qNameToNameWriteLock.lock();
        try {
            if (this.qNameToNameCache.size() > this.maxSize) {
                this.qNameToNameCache.clear();
            }
            this.qNameToNameCache.put(qName, name);
        }
        finally {
            this.qNameToNameWriteLock.unlock();
        }
    }

    public QName getQName(String name) {
        this.nameToQNameReadLock.lock();
        try {
            if (this.nameToQNameCache.size() > this.maxSize) {
                this.nameToQNameCache.clear();
            }
            QName qName = this.nameToQNameCache.get(name);
            return qName;
        }
        finally {
            this.nameToQNameReadLock.unlock();
        }
    }

    public void putNameToQName(String name, QName qName) {
        this.nameToQNameWriteLock.lock();
        try {
            this.nameToQNameCache.put(name, qName);
        }
        finally {
            this.nameToQNameWriteLock.unlock();
        }
    }

    public void clear() {
        this.nameToQNameWriteLock.lock();
        try {
            this.nameToQNameCache.clear();
        }
        finally {
            this.nameToQNameWriteLock.unlock();
        }
        this.qNameToNameWriteLock.lock();
        try {
            this.qNameToNameCache.clear();
        }
        finally {
            this.qNameToNameWriteLock.unlock();
        }
    }
}

