/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

@AlfrescoPublicApi
public final class Path
implements Iterable<Element>,
Serializable {
    private static final long serialVersionUID = 3905520514524328247L;
    private LinkedList<Element> elements = new LinkedList();

    @Override
    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    public Path prepend(Element pathElement) {
        this.elements.addFirst(pathElement);
        return this;
    }

    public Path prepend(Path path) {
        this.elements.addAll(0, path.elements);
        return this;
    }

    public Path append(Element pathElement) {
        this.elements.addLast(pathElement);
        return this;
    }

    public Path append(Path path) {
        this.elements.addAll(path.elements);
        return this;
    }

    public Element first() {
        return this.elements.getFirst();
    }

    public Element last() {
        return this.elements.getLast();
    }

    public int size() {
        return this.elements.size();
    }

    public Element get(int n) {
        return this.elements.get(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (Element element : this.elements) {
            if (sb.length() > 1 || sb.length() == 1 && sb.charAt(0) != '/') {
                sb.append("/");
            }
            sb.append(element.getElementString());
        }
        return sb.toString();
    }

    public String toPrefixString(NamespacePrefixResolver resolver) {
        StringBuilder sb = new StringBuilder(128);
        for (Element element : this.elements) {
            if (sb.length() > 1 || sb.length() == 1 && sb.charAt(0) != '/') {
                sb.append("/");
            }
            sb.append(element.getPrefixedString(resolver));
        }
        return sb.toString();
    }

    public String toDisplayPath(NodeService nodeService, PermissionService permissionService) {
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            String elementString = null;
            Element element = this.elements.get(i);
            if (element instanceof ChildAssocElement) {
                ChildAssociationRef elementRef = ((ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    Serializable nameProp = null;
                    if (permissionService.hasPermission(elementRef.getChildRef(), "Read") == AccessStatus.ALLOWED) {
                        nameProp = nodeService.getProperty(elementRef.getChildRef(), ContentModel.PROP_NAME);
                        elementString = nameProp.toString();
                    } else {
                        elementString = elementRef.getQName().getLocalName();
                    }
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append("/");
            buf.append(elementString);
        }
        return buf.toString();
    }

    public Path subPath(int depth) {
        return this.subPath(0, depth);
    }

    public Path subPath(int start, int end) {
        if (start < 0 || start > this.elements.size() - 1) {
            throw new IndexOutOfBoundsException("Start index " + start + " must be between 0 and " + (this.elements.size() - 1));
        }
        if (end < 0 || end > this.elements.size() - 1) {
            throw new IndexOutOfBoundsException("End index " + end + " must be between 0 and " + (this.elements.size() - 1));
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("End index " + end + " cannot be before start index " + start);
        }
        Path subPath = new Path();
        for (int i = start; i <= end; ++i) {
            subPath.append(this.get(i));
        }
        return subPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public Path getBaseNamePath(TenantService tenantService) {
        Path basePath = new Path();
        for (Element element : this.elements) {
            basePath.append(element.getBaseNameElement(tenantService));
        }
        return basePath;
    }

    @AlfrescoPublicApi
    public static abstract class Element
    implements Serializable {
        private static final long serialVersionUID = 5396069341092867660L;

        public abstract String getElementString();

        @AlfrescoPublicApi
        public abstract Element getBaseNameElement(TenantService var1);

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.getElementString();
        }

        public String toString() {
            return this.getElementString();
        }
    }

    @AlfrescoPublicApi
    public static class ChildAssocElement
    extends Element {
        private static final long serialVersionUID = 3689352104636790840L;
        private ChildAssociationRef ref;

        public ChildAssocElement(ChildAssociationRef ref) {
            this.ref = ref;
        }

        @Override
        public String getElementString() {
            return this.createElementString(null);
        }

        @Override
        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.createElementString(resolver);
        }

        public ChildAssociationRef getRef() {
            return this.ref;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildAssocElement)) {
                return false;
            }
            ChildAssocElement other = (ChildAssocElement)o;
            return this.ref.equals(other.ref);
        }

        public int hashCode() {
            return this.ref.hashCode();
        }

        private String createElementString(NamespacePrefixResolver resolver) {
            StringBuilder sb = new StringBuilder(32);
            if (this.ref.getParentRef() == null) {
                sb.append("/");
            } else {
                sb.append(resolver == null ? ISO9075.getXPathName(this.ref.getQName()) : ISO9075.getXPathName(this.ref.getQName(), resolver));
            }
            if (this.ref.getNthSibling() > -1) {
                sb.append("[").append(this.ref.getNthSibling()).append("]");
            }
            return sb.toString();
        }

        @Override
        public Element getBaseNameElement(TenantService tenantService) {
            return new ChildAssocElement(new ChildAssociationRef(this.ref.getTypeQName(), tenantService.getBaseName(this.ref.getParentRef(), true), this.ref.getQName(), tenantService.getBaseName(this.ref.getChildRef(), true), this.ref.isPrimary(), this.ref.getNthSibling()));
        }
    }

    @AlfrescoPublicApi
    public static class ParentElement
    extends Element {
        private static final long serialVersionUID = 3689915080477456179L;

        @Override
        public String getElementString() {
            return "..";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ParentElement;
        }

        public int hashCode() {
            return "..".hashCode();
        }

        @Override
        public Element getBaseNameElement(TenantService tenantService) {
            return new ParentElement();
        }
    }

    @AlfrescoPublicApi
    public static class SelfElement
    extends Element {
        private static final long serialVersionUID = 3834311739151300406L;

        @Override
        public String getElementString() {
            return ".";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof SelfElement;
        }

        public int hashCode() {
            return ".".hashCode();
        }

        @Override
        public Element getBaseNameElement(TenantService tenantService) {
            return new SelfElement();
        }
    }

    @AlfrescoPublicApi
    public static class DescendentOrSelfElement
    extends Element {
        private static final long serialVersionUID = 3258410616875005237L;

        @Override
        public String getElementString() {
            return "descendant-or-self::node()";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof DescendentOrSelfElement;
        }

        public int hashCode() {
            return "descendant-or-self::node()".hashCode();
        }

        @Override
        public Element getBaseNameElement(TenantService tenantService) {
            return new DescendentOrSelfElement();
        }
    }

    @AlfrescoPublicApi
    public static class AttributeElement
    extends Element {
        private static final long serialVersionUID = 3256727281668863544L;
        private QName attribute;
        private int position = -1;

        public AttributeElement(QName attribute) {
            this.attribute = attribute;
        }

        public AttributeElement(QName attribute, int position) {
            this(attribute);
            this.position = position;
        }

        public AttributeElement(String attribute) {
            String qNameStr = null;
            int idx = attribute.indexOf("[");
            if (idx != -1) {
                String positionStr = attribute.substring(idx + 1, attribute.length() - 1);
                this.position = Integer.parseInt(positionStr);
                qNameStr = attribute.substring(1, idx);
            } else {
                qNameStr = attribute.substring(1);
            }
            this.attribute = ISO9075.parseXPathName(qNameStr);
        }

        @Override
        public String getElementString() {
            return this.createElementString(null);
        }

        @Override
        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.createElementString(resolver);
        }

        private String createElementString(NamespacePrefixResolver resolver) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("@").append(resolver == null ? ISO9075.getXPathName(this.attribute) : ISO9075.getXPathName(this.attribute, resolver));
            if (this.position > -1) {
                sb.append("[").append(this.position).append("]");
            }
            return sb.toString();
        }

        public QName getQName() {
            return this.attribute;
        }

        public int position() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeElement)) {
                return false;
            }
            AttributeElement other = (AttributeElement)o;
            return this.getQName().equals(other.getQName()) && this.position() == other.position();
        }

        public int hashCode() {
            return this.getQName().hashCode() * 32 + this.position();
        }

        @Override
        public Element getBaseNameElement(TenantService tenantService) {
            return new AttributeElement(this.attribute, this.position);
        }
    }
}

