/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class ObjectIdLuceneBuilder
extends BaseLuceneBuilder {
    private DictionaryService dictionaryService;

    public ObjectIdLuceneBuilder(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public String getLuceneFieldName() {
        return "ID";
    }

    private <Q, S, E extends Throwable> StoreRef getStore(QueryParserAdaptor<Q, S, E> lqpa) {
        List stores = lqpa.getSearchParameters().getStores();
        if (((ArrayList)stores).size() < 1) {
            return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        }
        return (StoreRef)((ArrayList)stores).get(0);
    }

    private <Q, S, E extends Throwable> String getValueAsString(QueryParserAdaptor<Q, S, E> lqpa, Serializable value) {
        Object nodeRefStr = null;
        if (!NodeRef.isNodeRef((String)((Object)value))) {
            StoreRef storeRef = this.getStore(lqpa);
            nodeRefStr = storeRef.toString() + "/" + (String)((Object)value);
        } else {
            nodeRefStr = (String)((Object)value);
        }
        Object converted = DefaultTypeConverter.INSTANCE.convert(this.dictionaryService.getDataType(DataTypeDefinition.NODE_REF), nodeRefStr);
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
        return asString;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqpa, value);
        return lqpa.getIdentifierQuery(field, stringValue, AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchAllQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'greater than' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'greater than or equals' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'less than' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new CmisInvalidArgumentException("Property cmis:objectId can not be used in a 'less than or equals' comparison");
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, Boolean not) throws E {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(lqpa, value);
        Q q = lqpa.getIdentifieLikeQuery(field, stringValue, AnalysisMode.IDENTIFIER);
        if (not.booleanValue()) {
            q = lqpa.getNegatedQuery(q);
        }
        return q;
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) {
        return this.getLuceneFieldName();
    }
}

