/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.SearchLanguageConversion;

public class FixedValueLuceneBuilder
extends BaseLuceneBuilder {
    private Serializable value;

    public FixedValueLuceneBuilder(Serializable value) {
        this.value = value;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (EqualsHelper.nullSafeEquals((Object)value, (Object)value)) {
            return lqpa.getMatchAllQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            if (this.value == null) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        if (this.value == null) {
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchAllQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(value) > 0) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(value) >= 0) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneIn(QueryParserAdaptor<Q, S, E> lqpa, Collection<Serializable> values, Boolean not, PredicateMode mode) throws E {
        boolean in = false;
        for (Serializable value : values) {
            if (!EqualsHelper.nullSafeEquals((Object)value, (Object)value)) continue;
            in = true;
            break;
        }
        if (in == (not == false)) {
            return lqpa.getMatchAllQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneInequality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (!EqualsHelper.nullSafeEquals((Object)value, (Object)value)) {
            return lqpa.getMatchAllQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(value) < 0) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        if (value instanceof Comparable) {
            Comparable comparable = (Comparable)((Object)value);
            if (comparable.compareTo(value) <= 0) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, Boolean not) throws E {
        if (value != null) {
            String target;
            boolean matches = false;
            Object converted = DefaultTypeConverter.INSTANCE.convert(value.getClass(), (Object)value);
            String asString = DefaultTypeConverter.INSTANCE.convert(String.class, converted);
            String regExpression = SearchLanguageConversion.convertSQLLikeToRegex(asString);
            Pattern pattern = Pattern.compile(regExpression);
            Matcher matcher = pattern.matcher(target = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value));
            if (matcher.matches()) {
                matches = true;
            }
            if (matches == (not == false)) {
                return lqpa.getMatchAllQuery();
            }
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchNoneQuery();
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLuceneFieldName() {
        throw new UnsupportedOperationException();
    }
}

