/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import junit.framework.TestCase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class PathTest
extends TestCase {
    private Path absolutePath;
    private Path relativePath;
    private QName typeQName;
    private QName qname;
    private StoreRef storeRef;
    private NodeRef parentRef;
    private NodeRef childRef;

    public PathTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.absolutePath = new Path();
        this.relativePath = new Path();
        this.typeQName = QName.createQName((String)"http://www.alfresco.org/PathTest/1.0", (String)"testType");
        this.qname = QName.createQName((String)"http://www.google.com", (String)"documentx");
        this.storeRef = new StoreRef("x", "y");
        this.parentRef = new NodeRef(this.storeRef, "P");
        this.childRef = new NodeRef(this.storeRef, "C");
    }

    public void testQNameElement() throws Exception {
        Path.ChildAssocElement element = new Path.ChildAssocElement(new ChildAssociationRef(this.typeQName, this.parentRef, this.qname, this.childRef));
        PathTest.assertEquals((String)"Element string incorrect", (String)this.qname.toString(), (String)element.getElementString());
        element = new Path.ChildAssocElement(new ChildAssociationRef(this.typeQName, this.parentRef, this.qname, this.childRef, true, 5));
        PathTest.assertEquals((String)"Element string incorrect", (String)"{http://www.google.com}documentx[5]", (String)element.getElementString());
    }

    public void testElementTypes() throws Exception {
        Path.DescendentOrSelfElement element = new Path.DescendentOrSelfElement();
        PathTest.assertEquals((String)"DescendentOrSelf element incorrect", (String)"descendant-or-self::node()", (String)element.getElementString());
        element = new Path.ParentElement();
        PathTest.assertEquals((String)"Parent element incorrect", (String)"..", (String)element.getElementString());
        element = new Path.SelfElement();
        PathTest.assertEquals((String)"Self element incorrect", (String)".", (String)element.getElementString());
    }

    public void testAppendingAndPrepending() throws Exception {
        Path.ChildAssocElement element0 = new Path.ChildAssocElement(new ChildAssociationRef(null, null, null, this.parentRef));
        Path.ChildAssocElement element1 = new Path.ChildAssocElement(new ChildAssociationRef(this.typeQName, this.parentRef, this.qname, this.childRef, true, 4));
        Path.DescendentOrSelfElement element2 = new Path.DescendentOrSelfElement();
        Path.ParentElement element3 = new Path.ParentElement();
        Path.SelfElement element4 = new Path.SelfElement();
        this.absolutePath.append((Path.Element)element0).append((Path.Element)element1).append((Path.Element)element2).append((Path.Element)element3).append((Path.Element)element4);
        this.relativePath.append((Path.Element)element1).append((Path.Element)element2).append((Path.Element)element3).append((Path.Element)element4);
        PathTest.assertEquals((String)"Path appending didn't work", (String)"/{http://www.google.com}documentx[4]/descendant-or-self::node()/../.", (String)this.absolutePath.toString());
        Path copy = new Path();
        copy.append(this.relativePath).append(this.relativePath);
        PathTest.assertEquals((String)"Path appending didn't work", (String)(this.relativePath.toString() + "/" + this.relativePath.toString()), (String)copy.toString());
        this.relativePath.prepend((Path.Element)element2);
        PathTest.assertEquals((String)"Prepending didn't work", (String)"descendant-or-self::node()/{http://www.google.com}documentx[4]/descendant-or-self::node()/../.", (String)this.relativePath.toString());
    }
}

