/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.parsers;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.parsers.FTSQueryException;
import org.alfresco.repo.search.impl.querymodel.FunctionArgument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

public class AlfrescoFunctionEvaluationContext
implements FunctionEvaluationContext {
    private static HashSet<String> EXPOSED_FIELDS = new HashSet();
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;
    private String defaultNamespace;

    public AlfrescoFunctionEvaluationContext(NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, String defaultNamespace) {
        this.namespacePrefixResolver = namespacePrefixResolver;
        this.dictionaryService = dictionaryService;
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Boolean not) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThan(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneGreaterThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneIn(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Collection<Serializable> values, Boolean not, PredicateMode mode) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneInequality(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThan(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLessThanOrEquals(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneLike(QueryParserAdaptor<Q, S, E> lqpa, String propertyName, Serializable value, Boolean not) throws E {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Q, S, E extends Throwable> String getLuceneSortField(QueryParserAdaptor<Q, S, E> lqpa, String propertyName) throws E {
        if (propertyName.equalsIgnoreCase("Score")) {
            return "Score";
        }
        String field = this.getLuceneFieldName(propertyName);
        if (field.startsWith("@")) {
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(QName.createQName(field.substring(1)));
            if (propertyDef == null) {
                if (field.endsWith(".size")) {
                    propertyDef = this.dictionaryService.getProperty(QName.createQName(field.substring(1, field.length() - ".size".length())));
                    if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                        throw new FTSQueryException("Order for .size only supported on content properties");
                    }
                    return field;
                }
                if (field.endsWith(".mimetype")) {
                    propertyDef = this.dictionaryService.getProperty(QName.createQName(field.substring(1, field.length() - ".mimetype".length())));
                    if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                        throw new FTSQueryException("Order for .mimetype only supported on content properties");
                    }
                    return field;
                }
                return field;
            }
            if (propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException("Order on content properties is not curently supported");
            }
            if (propertyDef.getDataType().getName().equals(DataTypeDefinition.TEXT)) {
                if (propertyDef.getIndexTokenisationMode() == IndexTokenisationMode.FALSE) {
                    return field;
                }
                String noLocalField = field + ".no_locale";
                if (lqpa.sortFieldExists(noLocalField)) {
                    return noLocalField;
                }
                field = this.findSortField(lqpa, field);
            } else if (propertyDef.getDataType().getName().equals(DataTypeDefinition.MLTEXT)) {
                field = this.findSortField(lqpa, field);
            } else if (propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                field = lqpa.getDatetimeSortField(field, propertyDef);
            }
        }
        return field;
    }

    private <Q, S, E extends Throwable> String findSortField(QueryParserAdaptor<Q, S, E> lqpa, String field) throws E {
        return lqpa.getSortField(field);
    }

    @Override
    public Map<String, NodeRef> getNodeRefs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeService getNodeService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float getScore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Float> getScores() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isObjectId(String propertyName) {
        return false;
    }

    @Override
    public boolean isOrderable(String fieldName) {
        return true;
    }

    @Override
    public boolean isQueryable(String fieldName) {
        return true;
    }

    @Override
    public String getLuceneFieldName(String propertyName) {
        if (propertyName.startsWith("@")) {
            return propertyName;
        }
        if (propertyName.startsWith("{")) {
            QName fullQName = QName.createQName(propertyName);
            QName propertyQName = this.stripSuffixes(fullQName);
            if (this.dictionaryService.getProperty(propertyQName) != null) {
                return "@" + fullQName.toString();
            }
            if (this.dictionaryService.getDataType(fullQName) != null) {
                return fullQName.toString();
            }
            throw new FTSQueryException("Unknown property: " + fullQName.toString());
        }
        int index = propertyName.indexOf(58);
        if (index != -1) {
            QName fullQName = QName.createQName(propertyName, this.namespacePrefixResolver);
            QName propertyQName = this.stripSuffixes(fullQName);
            if (this.dictionaryService.getProperty(propertyQName) != null) {
                return "@" + fullQName.toString();
            }
            if (this.dictionaryService.getDataType(fullQName) != null) {
                return fullQName.toString();
            }
            throw new FTSQueryException("Unknown property: " + fullQName.toString());
        }
        if (!EXPOSED_FIELDS.contains(propertyName) && (index = propertyName.indexOf(95)) != -1) {
            QName fullQName = QName.createQName(propertyName.substring(0, index), propertyName.substring(index + 1), this.namespacePrefixResolver);
            QName propertyQName = this.stripSuffixes(fullQName);
            if (this.dictionaryService.getProperty(propertyQName) != null) {
                return "@" + fullQName.toString();
            }
            throw new FTSQueryException("Unknown property: " + fullQName.toString());
        }
        if (EXPOSED_FIELDS.contains(propertyName)) {
            return propertyName;
        }
        QName fullQName = QName.createQName(this.defaultNamespace, propertyName);
        QName propertyQName = this.stripSuffixes(fullQName);
        if (this.dictionaryService.getProperty(propertyQName) != null) {
            return "@" + fullQName.toString();
        }
        if (this.dictionaryService.getDataType(fullQName) != null) {
            return fullQName.toString();
        }
        if (propertyName.equalsIgnoreCase("Score")) {
            return propertyName.toLowerCase();
        }
        throw new FTSQueryException("Unknown property: " + fullQName.toString());
    }

    public QName stripSuffixes(QName qname) {
        String field = qname.toString();
        if (field.endsWith(".size")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".size".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".size only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".locale")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".locale".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".locale only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".mimetype")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".mimetype".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".mimetype only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".encoding")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".encoding".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".encoding only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".transformationException")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".transformationException".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".transformationException only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".transformationStatus")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".transformationStatus".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".transformationStatus only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith(".transformationTime")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - ".transformationTime".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                throw new FTSQueryException(".transformationTime only supported on content properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_second")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_second".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_second only supported on datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_minute")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_minute".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_minute only supported on datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_hour")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_hour".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_hour only supported on datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_day_of_month")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_day_of_month".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_day_of_month only supported on date and datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_day_of_week")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_day_of_week".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_day_of_week only supported on date and datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_day_of_year")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_day_of_year".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_day_of_year only supported on date and datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_month")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_month".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_month only supported on date and datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_quarter")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_quarter".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_quarter only supported on date and datetime properties");
            }
            return propertyField;
        }
        if (field.endsWith("_unit_of_time_year")) {
            QName propertyField = QName.createQName(field.substring(0, field.length() - "_unit_of_time_year".length()));
            PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyField);
            if (!propertyDef.getDataType().getName().equals(DataTypeDefinition.DATE) && !propertyDef.getDataType().getName().equals(DataTypeDefinition.DATETIME)) {
                throw new FTSQueryException("_unit_of_time_year only supported on date and datetime properties");
            }
            return propertyField;
        }
        return qname;
    }

    @Override
    public LuceneFunction getLuceneFunction(FunctionArgument functionArgument) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkFieldApplies(Selector selector, String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMultiValued(String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlfrescoPropertyName(String propertyName) {
        return propertyName;
    }

    @Override
    public String getAlfrescoTypeName(String typeName) {
        return typeName;
    }

    static {
        EXPOSED_FIELDS.add("PATH");
        EXPOSED_FIELDS.add("TEXT");
        EXPOSED_FIELDS.add("ID");
        EXPOSED_FIELDS.add("id");
        EXPOSED_FIELDS.add("ISROOT");
        EXPOSED_FIELDS.add("ISNODE");
        EXPOSED_FIELDS.add("TX");
        EXPOSED_FIELDS.add("PARENT");
        EXPOSED_FIELDS.add("PRIMARYPARENT");
        EXPOSED_FIELDS.add("QNAME");
        EXPOSED_FIELDS.add("CLASS");
        EXPOSED_FIELDS.add("TYPE");
        EXPOSED_FIELDS.add("EXACTTYPE");
        EXPOSED_FIELDS.add("ASPECT");
        EXPOSED_FIELDS.add("EXACTASPECT");
        EXPOSED_FIELDS.add("ALL");
        EXPOSED_FIELDS.add("EXISTS");
        EXPOSED_FIELDS.add("ISUNSET");
        EXPOSED_FIELDS.add("ISNULL");
        EXPOSED_FIELDS.add("ISNOTNULL");
        EXPOSED_FIELDS.add("FTSSTATUS");
        EXPOSED_FIELDS.add("FTSREF");
        EXPOSED_FIELDS.add("ASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("PRIMARYASSOCTYPEQNAME");
        EXPOSED_FIELDS.add("PRIMARYASSOCQNAME");
        EXPOSED_FIELDS.add("DBID");
        EXPOSED_FIELDS.add("TAG");
        EXPOSED_FIELDS.add("ACLID");
        EXPOSED_FIELDS.add("OWNER");
        EXPOSED_FIELDS.add("READER");
        EXPOSED_FIELDS.add("AUTHORITY");
        EXPOSED_FIELDS.add("OWNERSET");
        EXPOSED_FIELDS.add("READERSET");
        EXPOSED_FIELDS.add("AUTHSET");
        EXPOSED_FIELDS.add("DENIED");
        EXPOSED_FIELDS.add("DENYSET");
        EXPOSED_FIELDS.add("TXID");
        EXPOSED_FIELDS.add("ACLTXID");
        EXPOSED_FIELDS.add("TXCOMMITTIME");
        EXPOSED_FIELDS.add("ACLTXCOMMITTIME");
        EXPOSED_FIELDS.add("INACLTXID");
        EXPOSED_FIELDS.add("INTXID");
        EXPOSED_FIELDS.add("TENANT");
        EXPOSED_FIELDS.add("ANCESTOR");
        EXPOSED_FIELDS.add("EXCEPTIONMESSAGE");
        EXPOSED_FIELDS.add("EXCEPTIONSTACK");
        EXPOSED_FIELDS.add("LID");
        EXPOSED_FIELDS.add("PARENTASSOCCRC");
        EXPOSED_FIELDS.add("SITE");
        EXPOSED_FIELDS.add("TAG");
        EXPOSED_FIELDS.add("PNAME");
        EXPOSED_FIELDS.add("NPATH");
        EXPOSED_FIELDS.add("ANAME");
        EXPOSED_FIELDS.add("APATH");
        EXPOSED_FIELDS.add("DOC_TYPE");
        EXPOSED_FIELDS.add("PROPERTIES");
        EXPOSED_FIELDS.add("NULLPROPERTIES");
        EXPOSED_FIELDS.add("FINGERPRINT");
    }
}

