/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserExpressionAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseDisjunction;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.util.Pair;

public class LuceneDisjunction<Q, S, E extends Throwable>
extends BaseDisjunction
implements LuceneQueryBuilderComponent<Q, S, E> {
    public LuceneDisjunction(List<Constraint> constraints) {
        super(constraints);
    }

    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        QueryParserExpressionAdaptor<Q, E> expressionBuilder = luceneContext.getLuceneQueryParserAdaptor().getExpressionAdaptor();
        ArrayList<Pair> queriestoDisjoin = new ArrayList<Pair>();
        for (Constraint constraint : this.getConstraints()) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Q constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, functionArgs, luceneContext, functionContext);
                queriestoDisjoin.add(new Pair((Object)constraint, constraintQuery));
                if (constraintQuery == null) continue;
                switch (constraint.getOccur()) {
                    case DEFAULT: 
                    case MANDATORY: 
                    case OPTIONAL: {
                        expressionBuilder.addOptional(constraintQuery, constraint.getBoost());
                        break;
                    }
                    case EXCLUDE: {
                        QueryParserExpressionAdaptor<Q, E> subExpressionBuilder = luceneContext.getLuceneQueryParserAdaptor().getExpressionAdaptor();
                        subExpressionBuilder.addRequired(luceneContext.getLuceneQueryParserAdaptor().getMatchAllNodesQuery());
                        subExpressionBuilder.addExcluded(constraintQuery);
                        expressionBuilder.addOptional(subExpressionBuilder.getQuery(), constraint.getBoost());
                    }
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return expressionBuilder.getQuery();
    }
}

