/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Child;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class LuceneChild<Q, S, E extends Throwable>
extends Child
implements LuceneQueryBuilderComponent<Q, S, E> {
    private StoreRef getStore(QueryBuilderContext<Q, S, E> luceneContext) {
        List stores = luceneContext.getLuceneQueryParserAdaptor().getSearchParameters().getStores();
        if (((ArrayList)stores).size() < 1) {
            return StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        }
        return (StoreRef)((ArrayList)stores).get(0);
    }

    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        NodeRef nodeRef;
        QueryParserAdaptor<Q, S, E> lqpa = luceneContext.getLuceneQueryParserAdaptor();
        Argument argument = functionArgs.get("Parent");
        String id = (String)((Object)argument.getValue(functionContext));
        argument = functionArgs.get("Selector");
        if (argument != null) {
            String selector = (String)((Object)argument.getValue(functionContext));
            if (!selectors.contains(selector)) {
                throw new QueryModelException("Unkown selector " + selector);
            }
        } else if (selectors.size() > 1) {
            throw new QueryModelException("Selector must be specified for child constraint (IN_FOLDER) and join");
        }
        if (NodeRef.isNodeRef(id)) {
            nodeRef = new NodeRef(id);
        } else {
            StoreRef storeRef = this.getStore(luceneContext);
            nodeRef = new NodeRef(storeRef, id);
        }
        Q query = lqpa.getFieldQuery("PARENT", nodeRef.toString());
        return query;
    }
}

