/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.encoding;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.util.DataModelTestApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class CharsetFinderTest
extends TestCase {
    private static ApplicationContext ctx = DataModelTestApplicationContextHelper.getApplicationContext();
    private ContentCharsetFinder charsetFinder;

    public void setUp() throws Exception {
        this.charsetFinder = (ContentCharsetFinder)ctx.getBean("charset.finder");
    }

    public void testPlainText() throws Exception {
        String test = "The quick brown fox jumps over the lazy dog\n\nLe renard brun rapide saute par-dessus le chien paresseux\n\nDer schnelle braune Fuchs springt \u00fcber den faulen Hund\n\n\u0628\u0631\u0627\u0648\u0646 \u0648\u0643\u0633 \u0627\u0644\u0633\u0631\u064a\u0639 \u064a\u0642\u0641\u0632 \u0641\u0648\u0642 \u0627\u0644\u0643\u0644\u0628 \u0643\u0633\u0627\u0644\u064a";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes(StandardCharsets.UTF_8)));
        Charset charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-8", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes(StandardCharsets.UTF_16)));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16BE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UnicodeBig")));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16BE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UnicodeLittle")));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-16LE", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(test.getBytes("UTF-32")));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"UTF-32BE", (String)charset.displayName());
    }

    public void test8BitText() throws Exception {
        String forIso88591 = "En fran\u00e7ais o\u00f9 les choses sont accentu\u00e9s. En espa\u00f1ol, as\u00ed";
        String forIso88597 = "\u0391\u03c5\u03c4\u03cc \u03b5\u03af\u03bd\u03b1\u03b9 \u03c3\u03c4\u03b7\u03bd \u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1";
        String forCp1251 = "\u042d\u0442\u043e \u0432 \u0440\u0443\u0441\u0441\u043a\u043e\u043c \u044f\u0437\u044b\u043a\u0435, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(forIso88591.getBytes(StandardCharsets.ISO_8859_1)));
        Charset charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"ISO-8859-1", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(forIso88597.getBytes("ISO-8859-7")));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"ISO-8859-7", (String)charset.displayName());
        is = new BufferedInputStream(new ByteArrayInputStream(forCp1251.getBytes("CP1251")));
        charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"windows-1251", (String)charset.displayName());
    }

    public void testShiftJSHtml() throws Exception {
        String forShiftJs = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=Shift_JIS\"><title>\u78ba\u8a8d\u3057\u305f\u7d50\u679c\u3092\u6dfb\u4ed8\u3057\u307e\u3059\u306e\u3067\u3001\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044</title>\r\n<h3>\u7279\u8a31\u5370\u7d19\u306e\u58f2\u308a\u3055\u3070\u304d\u306b\u95a2\u3059\u308b\u7701\u4ee4</h3></html>";
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(forShiftJs.getBytes("Shift_JIS")));
        Charset charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((Object)charset);
        CharsetFinderTest.assertEquals((String)"Shift_JIS", (String)charset.displayName());
    }

    public void testBlankFileCharsetDetection() {
        byte[] blankContent = new byte[]{};
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(blankContent));
        Charset charset = this.charsetFinder.getCharset((InputStream)is, "text/plain");
        CharsetFinderTest.assertNotNull((String)"Charset should not be null for blank files", (Object)charset);
        CharsetFinderTest.assertEquals((String)charset.displayName(), (String)StandardCharsets.UTF_8.displayName());
    }
}

