/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.mapping;

import java.io.Serializable;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.BaseLuceneBuilder;
import org.alfresco.repo.search.adaptor.AnalysisMode;
import org.alfresco.repo.search.adaptor.LuceneFunction;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;

public class BaseTypeIdLuceneBuilder
extends BaseLuceneBuilder {
    private CMISDictionaryService dictionaryService;

    public BaseTypeIdLuceneBuilder(CMISDictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneEquality(QueryParserAdaptor<Q, S, E> lqpa, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws E {
        return lqpa.getFieldQuery("TYPE", this.getType(this.getValueAsString(value)), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public <Q, S, E extends Throwable> Q buildLuceneExists(QueryParserAdaptor<Q, S, E> lqpa, Boolean not) throws E {
        if (not.booleanValue()) {
            return lqpa.getMatchNoneQuery();
        }
        return lqpa.getMatchAllQuery();
    }

    private String getType(String tableName) {
        TypeDefinitionWrapper typeDef = this.dictionaryService.findTypeByQueryName(tableName);
        if (typeDef == null) {
            throw new CmisInvalidArgumentException("Unknown type: " + tableName);
        }
        if (!typeDef.isBaseType()) {
            throw new CmisInvalidArgumentException("Not a base type: " + tableName);
        }
        if (!typeDef.getTypeDefinition(false).isQueryable().booleanValue()) {
            throw new CmisInvalidArgumentException("Type is not queryable: " + tableName);
        }
        return typeDef.getAlfrescoClass().toString();
    }

    private String getValueAsString(Serializable value) {
        String asString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }
}

