/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

@AlfrescoPublicApi
public class ChildAssociationRef
implements EntityRef,
Comparable<ChildAssociationRef>,
Serializable {
    private static final long serialVersionUID = 4051322336257127729L;
    private static final String FILLER = "|";
    private QName assocTypeQName;
    private NodeRef parentRef;
    private QName childQName;
    private NodeRef childRef;
    private boolean isPrimary;
    private int nthSibling;

    public ChildAssociationRef(QName assocTypeQName, NodeRef parentRef, QName childQName, NodeRef childRef, boolean isPrimary, int nthSibling) {
        this.assocTypeQName = assocTypeQName;
        this.parentRef = parentRef;
        this.childQName = childQName;
        this.childRef = childRef;
        this.isPrimary = isPrimary;
        this.nthSibling = nthSibling;
        if (childRef == null) {
            throw new IllegalArgumentException("Child reference may not be null");
        }
    }

    public ChildAssociationRef(QName assocTypeQName, NodeRef parentRef, QName childQName, NodeRef childRef) {
        this(assocTypeQName, parentRef, childQName, childRef, false, -1);
    }

    public ChildAssociationRef(String childAssocRefStr) {
        StringTokenizer tokenizer = new StringTokenizer(childAssocRefStr, FILLER);
        if (tokenizer.countTokens() != 6) {
            throw new AlfrescoRuntimeException("Unable to parse child association string: " + childAssocRefStr);
        }
        String parentNodeRefStr = tokenizer.nextToken();
        String childNodeRefStr = tokenizer.nextToken();
        String assocTypeQNameStr = tokenizer.nextToken();
        String assocQNameStr = tokenizer.nextToken();
        String isPrimaryStr = tokenizer.nextToken();
        String nthSiblingStr = tokenizer.nextToken();
        this.parentRef = new NodeRef(parentNodeRefStr);
        this.childRef = new NodeRef(childNodeRefStr);
        this.assocTypeQName = QName.createQName(assocTypeQNameStr);
        this.childQName = QName.createQName(assocQNameStr);
        this.isPrimary = Boolean.parseBoolean(isPrimaryStr);
        this.nthSibling = Integer.parseInt(nthSiblingStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append(this.parentRef).append(FILLER).append(this.childRef).append(FILLER).append(this.assocTypeQName).append(FILLER).append(this.childQName).append(FILLER).append(this.isPrimary).append(FILLER).append(this.nthSibling);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChildAssociationRef)) {
            return false;
        }
        ChildAssociationRef other = (ChildAssociationRef)o;
        return EqualsHelper.nullSafeEquals((Object)this.assocTypeQName, (Object)other.assocTypeQName) && EqualsHelper.nullSafeEquals((Object)this.parentRef, (Object)other.parentRef) && EqualsHelper.nullSafeEquals((Object)this.childQName, (Object)other.childQName) && EqualsHelper.nullSafeEquals((Object)this.childRef, (Object)other.childRef);
    }

    public int hashCode() {
        int hashCode = this.getTypeQName() == null ? 0 : this.getTypeQName().hashCode();
        hashCode = 37 * hashCode + (this.getParentRef() == null ? 0 : this.getParentRef().hashCode());
        hashCode = 37 * hashCode + (this.getQName() == null ? 0 : this.getQName().hashCode());
        hashCode = 37 * hashCode + this.getChildRef().hashCode();
        return hashCode;
    }

    @Override
    public int compareTo(ChildAssociationRef another) {
        int thisVal = this.nthSibling;
        int anotherVal = another.nthSibling;
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public QName getTypeQName() {
        return this.assocTypeQName;
    }

    public QName getQName() {
        return this.childQName;
    }

    public NodeRef getChildRef() {
        return this.childRef;
    }

    public NodeRef getParentRef() {
        return this.parentRef;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public int getNthSibling() {
        return this.nthSibling;
    }

    public void setNthSibling(int nthSibling) {
        this.nthSibling = nthSibling;
    }
}

