/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.files;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordProperties;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeclareDocumentAsRecordTests
extends BaseRMRestTest {
    private UserModel testUser;
    private UserModel testUserReadOnly;
    private SiteModel testSite;
    private FolderModel testFolder;
    @Autowired
    RecordsAPI recordsAPI;

    @BeforeClass(alwaysRun=true)
    public void declareDocumentAsRecordSetup() {
        this.testUser = this.getDataUser().createRandomTestUser();
        this.testUserReadOnly = this.getDataUser().createRandomTestUser();
        this.testSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.getDataUser().addUserToSite(this.testUser, this.testSite, UserRole.SiteContributor);
        this.getDataUser().addUserToSite(this.testUserReadOnly, this.testSite, UserRole.SiteConsumer);
        this.testFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).createFolder();
    }

    @Test(description="User with correct permissions can declare document as a record")
    @AlfrescoTest(jira="RM-4429, RM-6779")
    public void userWithPrivilegesCanDeclareDocumentAsRecord() throws Exception {
        FileModel document = ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Record record = this.getRestAPIFactory().getFilesAPI(this.testUser).declareAsRecord(document.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        List matchingRecords = unfiledContainersAPI.getUnfiledContainerChildren("-unfiled-").getEntries().stream().filter(e -> e.getEntry().getId().equals(document.getNodeRefWithoutVersion())).collect(Collectors.toList());
        Assert.assertEquals((int)matchingRecords.size(), (int)1, (String)"More than one record matching document name");
        List filesAfterRename = this.getRestAPIFactory().getNodeAPI((RepoTestModel)this.testFolder).listChildren().getEntries().stream().filter(f -> f.onModel().getId().equals(document.getNodeRefWithoutVersion())).collect(Collectors.toList());
        Assert.assertEquals((int)filesAfterRename.size(), (int)1, (String)("There should be only one file in folder " + this.testFolder.getName()));
        String recordName = ((RestNodeModel)filesAfterRename.get(0)).onModel().getName();
        Assert.assertEquals((String)recordName, (String)document.getName().replace(".", String.format(" (%s).", record.getProperties().getIdentifier())));
        Document documentPostFiling = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).getCMISDocument(this.testFolder.getCmisLocation() + "/" + recordName);
        List documentSecondary = documentPostFiling.getSecondaryTypes().stream().filter(t -> t.getDisplayName().equals("Record")).collect(Collectors.toList());
        Assert.assertFalse((boolean)documentSecondary.isEmpty(), (String)"Document is not a record");
        try (InputStream recordInputStream = this.getRestAPIFactory().getRecordsAPI().getRecordContent(record.getId()).asInputStream();
             InputStream documentInputStream = documentPostFiling.getContentStream().getStream();){
            Assert.assertEquals((Object)DigestUtils.sha1((InputStream)recordInputStream), (Object)DigestUtils.sha1((InputStream)documentInputStream));
        }
    }

    @Test(description="User with read-only permissions can't declare document a record")
    @AlfrescoTest(jira="RM-4429")
    public void userWithReadPermissionsCantDeclare() throws Exception {
        FileModel document = ((DataContent)((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).usingResource((ContentModel)this.testFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.getRestAPIFactory().getFilesAPI(this.testUserReadOnly).declareAsRecord(document.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.FORBIDDEN);
        List filesAfterRename = this.getRestAPIFactory().getNodeAPI((RepoTestModel)this.testFolder).listChildren().getEntries().stream().filter(f -> f.onModel().getId().equals(document.getNodeRefWithoutVersion())).collect(Collectors.toList());
        Assert.assertEquals((int)filesAfterRename.size(), (int)1, (String)"Declare as record failed but original document is missing");
    }

    @Test(description="Record can't be declared a record")
    @AlfrescoTest(jira="RM-4429")
    public void recordCantBeDeclaredARecord() {
        Record nonelectronicRecord = Record.builder().properties(RecordProperties.builder().description("Description").title("Title").build()).name("Non-Electronic Record").nodeType("rma:nonElectronicDocument").build();
        Record record = this.getRestAPIFactory().getRecordFolderAPI().createRecord(nonelectronicRecord, this.createCategoryFolderInFilePlan().getId());
        this.assertStatusCode(HttpStatus.CREATED);
        this.getRestAPIFactory().getFilesAPI().declareAsRecord(record.getId());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Node that is not a document can't be declared a record")
    @AlfrescoTest(jira="RM-4429")
    public void nonDocumentCantBeDeclaredARecord() {
        FolderModel otherTestFolder = ((DataContent)this.dataContent.usingSite(this.testSite)).usingUser(this.testUser).createFolder();
        this.getRestAPIFactory().getFilesAPI().declareAsRecord(otherTestFolder.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(description="Declaring as record a file that already has its version declared as record is successful")
    @AlfrescoTest(jira="RM-6786")
    public void declareAsRecordAFileWithARecordVersion() {
        Step.STEP((String)"Create a file.");
        FileModel testFile = ((DataContent)this.dataContent.usingAdmin().usingSite(this.testSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Declare file version as record and check that record is successfully created.");
        this.recordsAPI.declareDocumentVersionAsRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.testSite.getId(), testFile.getName());
        Step.STEP((String)"Declare file as record and check that record is successfully created.");
        this.getRestAPIFactory().getFilesAPI().declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
    }
}

