/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.files;

import java.io.File;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.DockerHelper;
import org.alfresco.rest.v0.HoldsAPI;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@AlfrescoTest(jira="APPS-35")
public class FileVersionAsRecordTests
extends BaseRMRestTest {
    private static final String DESTINATION_PATH_NOT_FOUND_EXC = "Unable to execute declare-version-record action, because the destination path could not be found.";
    private static final String INVALID_DESTINATION_PATH_EXC = "Unable to execute declare-version-record action, because the destination path is invalid.";
    private static final String DESTINATION_PATH_NOT_RECORD_FOLDER_EXC = "Unable to execute declare-version-record action, because the destination path is not a record folder.";
    private static final String ACCESS_DENIED_EXC = "Access Denied.  You do not have the appropriate permissions to perform this operation.";
    private static final String HOLD_NAME = RandomData.getRandomName((String)"holdName");
    private UserModel userFillingPermission;
    private UserModel userReadOnlyPermission;
    private SiteModel publicSite;
    private FileModel testFile;
    private FolderModel testFolder;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder;
    private RecordCategoryChild closedRecordFolder;
    private RecordCategoryChild heldRecordFolder;
    private UnfiledContainerChild unfiledContainerFolder;
    private String holdNodeRef;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DockerHelper dockerHelper;
    @Autowired
    private HoldsAPI holdsAPI;

    @BeforeClass(alwaysRun=true)
    public void declareAndFileVersionAsRecordSetup() {
        Step.STEP((String)"Create test collaboration site to store documents in.");
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        Step.STEP((String)"Create a test folder within the collaboration site");
        this.testFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(this.publicSite)).createFolder();
        Step.STEP((String)"Create record categories and record folders");
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.recordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        this.closedRecordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"closedRecordFolder"));
        this.closeFolder(this.closedRecordFolder.getId());
        this.unfiledContainerFolder = this.createUnfiledContainerChild("-unfiled-", "Unfiled Folder " + RandomData.getRandomAlphanumeric(), "rma:unfiledRecordFolder");
        this.heldRecordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"heldRecordFolder"));
        this.holdNodeRef = this.holdsAPI.createHoldAndGetNodeRef(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), HOLD_NAME, "Active content to be reviewed for the CASE McDermott, FINRA ", "Generalized hold case for tests");
        this.holdsAPI.addItemToHold(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.heldRecordFolder.getId(), HOLD_NAME);
        Step.STEP((String)"Create rm users with different permissions on the record category");
        this.userFillingPermission = this.roleService.createCollaboratorWithRMRoleAndPermission(this.publicSite, this.recordCategory, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_FILING);
        this.userReadOnlyPermission = this.roleService.createCollaboratorWithRMRoleAndPermission(this.publicSite, this.recordCategory, UserRoles.ROLE_RM_POWER_USER, UserPermissions.PERMISSION_READ_RECORDS);
    }

    @BeforeMethod(alwaysRun=true)
    public void createDocument() {
        Step.STEP((String)"Create a document in the collaboration site");
        this.testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @Test
    public void declareVersionAndFileNoLocationUsingActionsAPI() throws Exception {
        Step.STEP((String)"Declare document version as record without providing a location parameter value using v1 actions api");
        this.getRestAPIFactory().getActionsAPI(this.userReadOnlyPermission).declareVersionAsRecord((RepoTestModel)this.testFile);
        Step.STEP((String)"Verify the declared version record is placed in the Unfiled Records folder and is a record version");
        Assert.assertTrue((boolean)this.isRecordVersionInUnfiledRecords(this.testFile, "1.0"), (String)"Version record should be filed to Unfiled Records folder");
    }

    @Test
    public void fileVersionAsRecordToValidLocationUsingActionsAPI() throws Exception {
        Step.STEP((String)"Declare document version as record with a location parameter value");
        this.getRestAPIFactory().getActionsAPI(this.userFillingPermission).declareAndFileVersionAsRecord((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.recordFolder.getName()}));
        Step.STEP((String)"Verify the declared version record is placed in the record folder");
        Assert.assertTrue((boolean)this.isRecordVersionInRecordFolder(this.testFile, this.recordFolder, "1.0"), (String)"Record version should be filed to record folder");
    }

    @DataProvider(name="invalidDestinationPaths")
    public Object[][] getInvalidDestinationPaths() {
        return new String[][]{{"/", DESTINATION_PATH_NOT_FOUND_EXC}, {"Unfiled Records", INVALID_DESTINATION_PATH_EXC}, {"Transfers", INVALID_DESTINATION_PATH_EXC}, {"Holds", INVALID_DESTINATION_PATH_EXC}, {"rm/documentlibrary", DESTINATION_PATH_NOT_FOUND_EXC}, {this.recordCategory.getName(), DESTINATION_PATH_NOT_RECORD_FOLDER_EXC}, {Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.closedRecordFolder.getName()}), ACCESS_DENIED_EXC}, {Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.heldRecordFolder.getName()}), ACCESS_DENIED_EXC}, {"Unfiled Records/" + this.unfiledContainerFolder.getName(), INVALID_DESTINATION_PATH_EXC}, {this.testFolder.getCmisLocation(), DESTINATION_PATH_NOT_FOUND_EXC}};
    }

    @Test(dataProvider="invalidDestinationPaths")
    public void declareVersionAndFileToInvalidLocationUsingActionsAPI(String containerPath, String expectedException) throws Exception {
        Step.STEP((String)"Declare document as record version with an invalid location parameter value");
        this.getRestAPIFactory().getActionsAPI().declareAndFileVersionAsRecord((RepoTestModel)this.testFile, containerPath);
        this.assertStatusCode(HttpStatus.ACCEPTED);
        Step.STEP((String)"Check the exception thrown in alfresco logs");
        this.dockerHelper.checkExceptionIsInAlfrescoLogs(expectedException);
    }

    @Test
    public void declareAndFileByUserWithReadOnlyPermission() throws Exception {
        Step.STEP((String)"Declare document as record with a record folder as location parameter");
        this.getRestAPIFactory().getActionsAPI(this.userReadOnlyPermission).declareAndFileVersionAsRecord((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.recordFolder.getName()}));
        Step.STEP((String)"Check that the record version is not added to the record folder");
        Assert.assertFalse((boolean)this.isRecordVersionInRecordFolder(this.testFile, this.recordFolder, "1.0"), (String)"Record version is filed to record folder where the user doesn't have filling permission");
    }

    @Test
    public void declareVersionAsRecordMinorVersionUsingActionsAPI() throws Exception {
        Step.STEP((String)"Update document in the collaboration site");
        ((DataContent)((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().usingResource((ContentModel)this.testFile)).updateContent("This is the new contentfor " + this.testFile.getName());
        Step.STEP((String)"Declare document version as record with providing a location parameter value using v1 actions api");
        this.getRestAPIFactory().getActionsAPI(this.userFillingPermission).declareAndFileVersionAsRecord((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.recordFolder.getName()}));
        Step.STEP((String)"Verify the declared version record is placed in the record folder and is a record version");
        Assert.assertTrue((boolean)this.isRecordVersionInRecordFolder(this.testFile, this.recordFolder, "1.1"), (String)"Record should be filed to fileplan location");
    }

    @Test
    public void declareVersionAsRecordMajorVersionUsingActionsAPI() throws Exception {
        Step.STEP((String)"Update document in the collaboration site");
        File sampleFile = Utility.getResourceTestDataFile((String)"SampleTextFile_10kb.txt");
        ((RestCoreAPI)this.restClient.authenticateUser(this.getAdminUser()).withCoreAPI().usingParams(new String[]{"majorVersion=true"})).usingNode((RepoTestModel)this.testFile).updateNodeContent(sampleFile);
        Step.STEP((String)"Declare document version as record with providing a location parameter value using v1 actions api");
        this.getRestAPIFactory().getActionsAPI(this.userFillingPermission).declareAndFileVersionAsRecord((RepoTestModel)this.testFile, Utility.buildPath((String)this.recordCategory.getName(), (String[])new String[]{this.recordFolder.getName()}));
        Step.STEP((String)"Verify the declared version record is placed in the record folder and is a record version");
        Assert.assertTrue((boolean)this.isRecordVersionInRecordFolder(this.testFile, this.recordFolder, "2.0"), (String)"Version record should be filed to the record folder");
    }

    @AfterClass(alwaysRun=true)
    public void declareAndFileVersionAsRecordCleanUp() {
        this.holdsAPI.deleteHold(this.getAdminUser(), this.holdNodeRef);
        this.deleteRecordCategory(this.recordCategory.getId());
        this.dataSite.deleteSite(this.publicSite);
        this.getDataUser().deleteUser(this.userFillingPermission);
        this.getDataUser().deleteUser(this.userReadOnlyPermission);
    }
}

