/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.search;

import java.util.Arrays;
import org.alfresco.rest.core.search.SearchRequestBuilder;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.rest.search.SearchResponse;
import org.alfresco.rest.v0.UserTrashcanAPI;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SearchDocumentsV1Test
extends BaseRMRestTest {
    private static final String SEARCH_TERM = CommonTestUtils.generateTestPrefix(SearchDocumentsV1Test.class);
    private SiteModel collaborationSite;
    private FileModel fileModel;
    @Autowired
    private UserTrashcanAPI userTrashcanAPI;

    @DataProvider
    public static Object[][] queryTypes() {
        RestRequestQueryModel cmisQueryModel = new RestRequestQueryModel();
        cmisQueryModel.setQuery("select * from cmis:document WHERE cmis:name LIKE '%" + SEARCH_TERM + ".txt'");
        cmisQueryModel.setLanguage("cmis");
        RestRequestQueryModel aftsQueryModel = new RestRequestQueryModel();
        aftsQueryModel.setQuery("cm:name:*" + SEARCH_TERM);
        aftsQueryModel.setLanguage("afts");
        return new RestRequestQueryModel[][]{{cmisQueryModel}, {aftsQueryModel}};
    }

    @BeforeClass(alwaysRun=true)
    public void setupSearchDocumentsV1Test() throws Exception {
        Step.STEP((String)"Create a collaboration site");
        this.collaborationSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        Step.STEP((String)"Create 10 documents ending with SEARCH_TERM");
        int i = 0;
        while (++i <= 10) {
            this.fileModel = new FileModel(String.format("%s.%s", "Doc" + i + SEARCH_TERM, FileType.TEXT_PLAIN.extension));
            ((DataContent)this.dataContent.usingAdmin().usingSite(this.collaborationSite)).createContent(this.fileModel);
        }
        this.waitIndexing();
    }

    private void waitIndexing() throws Exception {
        RestRequestQueryModel queryType = new RestRequestQueryModel();
        queryType.setQuery("cm:name:*" + SEARCH_TERM);
        queryType.setLanguage("afts");
        Utility.sleep((int)1000, (int)80000, () -> {
            SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(queryType).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(100), Integer.valueOf(0))).setFieldsBuilder(Arrays.asList("id", "name"));
            SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI(null).search((SearchRequest)sqlRequest);
            Assert.assertEquals((int)searchResponse.getPagination().getTotalItems(), (int)10, (String)"Total number of items is not retrieved yet");
        });
    }

    @Test(dataProvider="queryTypes")
    public void searchWhenMaxItemsReach(RestRequestQueryModel queryType) {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(queryType).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(5))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI().search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)5, (String)"Expected maxItems to be five");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)5, (String)"Expected skip count to be five");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)5, (String)"Expected total entries to be five");
    }

    @Test(dataProvider="queryTypes")
    public void searchWhenTotalItemsExceed(RestRequestQueryModel queryType) {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(queryType).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(5), Integer.valueOf(6))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI().search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)6, (String)"Expected skip count to be six");
        Assert.assertFalse((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be false");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @Test(dataProvider="queryTypes")
    public void searchResultsUnderTotalItems(RestRequestQueryModel queryType) {
        SearchRequestBuilder sqlRequest = new SearchRequestBuilder().setQueryBuilder(queryType).setPagingBuilder(new SearchRequestBuilder().setPagination(Integer.valueOf(4), Integer.valueOf(5))).setFieldsBuilder(Arrays.asList("id", "name"));
        SearchResponse searchResponse = this.getRestAPIFactory().getSearchAPI().search((SearchRequest)sqlRequest);
        Assert.assertEquals((int)searchResponse.getPagination().getCount(), (int)4, (String)"Expected maxItems to be four");
        Assert.assertEquals((int)searchResponse.getPagination().getSkipCount(), (int)5, (String)"Expected skip count to be five");
        Assert.assertTrue((boolean)searchResponse.getPagination().isHasMoreItems(), (String)"Expected hasMoreItems to be true");
        Assert.assertEquals((int)searchResponse.getEntries().size(), (int)4, (String)"Expected total entries to be four");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.collaborationSite);
        this.userTrashcanAPI.emptyTrashcan(this.getAdminUser().getUsername(), this.getAdminUser().getPassword());
    }
}

