/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.v0;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.dataprep.ContentService;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;

public abstract class BaseAPI {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseAPI.class);
    private static final String EXCEPTION_KEY = "exception";
    private static final String MESSAGE_KEY = "message";
    public static final String NODE_PREFIX = "workspace/SpacesStore/";
    protected static final String UPDATE_METADATA_API = "{0}node/{1}/formprocessor";
    protected static final String ACTIONS_API = "{0}actionQueue";
    protected static final String RM_ACTIONS_API = "{0}rma/actions/ExecutionQueue";
    public static final String RM_SITE_ID = "rm";
    protected static final String SHARE_ACTION_API = "{0}internal/shared/share/workspace/SpacesStore/{1}";
    private static final String SLINGSHOT_PREFIX = "alfresco/s/slingshot/";
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;
    @Autowired
    protected ContentService contentService;
    public static final String NODE_REF_WORKSPACE_SPACES_STORE = "workspace://SpacesStore/";
    private static final String FILE_PLAN_PATH = "/Sites/rm/documentLibrary";

    protected List<String> getPropertyValues(JSONObject result, String propertyName) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            JSONArray items = result.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                results.add(items.getJSONObject(i).getString(propertyName));
            }
        }
        catch (JSONException error) {
            throw new RuntimeException("Unable to parse result", error);
        }
        return results;
    }

    protected String getPropertyValue(JSONObject result, String nodeRef, String propertyName) {
        String propertyValue = "";
        try {
            JSONArray items = result.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                JSONObject item = items.getJSONObject(i);
                if (!nodeRef.equals(item.getString("nodeRef"))) continue;
                propertyValue = item.getJSONObject("properties").getString(propertyName);
            }
        }
        catch (JSONException error) {
            throw new RuntimeException("Unable to parse result", error);
        }
        return propertyValue;
    }

    protected Map<String, List<String>> getPropertyValuesByUniquePropertyValue(JSONObject requestResult, String uniqueProperty, List<String> otherProperties) {
        HashMap<String, List<String>> valuesByUniqueProperty = new HashMap<String, List<String>>();
        try {
            JSONArray items = requestResult.getJSONArray("items");
            for (int i = 0; i < items.length(); ++i) {
                ArrayList<String> otherPropertiesValues = new ArrayList<String>();
                for (int j = 0; j < otherProperties.size(); ++j) {
                    otherPropertiesValues.add(items.getJSONObject(i).get(otherProperties.get(j)).toString());
                }
                valuesByUniqueProperty.put(items.getJSONObject(i).getString(uniqueProperty), otherPropertiesValues);
            }
        }
        catch (JSONException error) {
            throw new RuntimeException("Unable to parse result", error);
        }
        return valuesByUniqueProperty;
    }

    public String getItemNodeRef(String username, String password, String path) {
        return this.contentService.getNodeRefByPath(username, password, FILE_PLAN_PATH + path);
    }

    protected CmisObject getObjectByPath(String username, String password, String path) {
        CmisObject object;
        try {
            object = this.contentService.getCMISSession(username, password).getObjectByPath(path);
        }
        catch (CmisObjectNotFoundException notFoundError) {
            return null;
        }
        return object;
    }

    protected JSONObject facetedRequest(String username, String password, List<NameValuePair> parameters, String requestURI) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestURL = parameters == null || parameters.isEmpty() ? MessageFormat.format(requestURI, client.getAlfrescoUrl()) : MessageFormat.format(requestURI, client.getAlfrescoUrl(), URLEncodedUtils.format(parameters, (String)"UTF-8"));
        LOGGER.info("On GET {}, received following response: ", (Object)requestURL);
        client.close();
        return this.doGetRequest(username, password, requestURL, new String[0]);
    }

    protected JSONObject doGetRequest(String adminUser, String adminPassword, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestUrl = MessageFormat.format(urlTemplate, client.getApiUrl(), urlTemplateParams);
        client.close();
        try {
            return this.doRequest(HttpGet.class, requestUrl, adminUser, adminPassword, null);
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doGetRequest failed", error);
        }
    }

    protected JSONObject doDeleteRequest(String adminUser, String adminPassword, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestUrl = MessageFormat.format(urlTemplate, client.getApiUrl(), urlTemplateParams);
        client.close();
        try {
            return this.doRequest(HttpDelete.class, requestUrl, adminUser, adminPassword, null);
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doDeleteRequest failed", error);
        }
    }

    protected JSONObject doPutRequest(String adminUser, String adminPassword, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestUrl = MessageFormat.format(urlTemplate, client.getApiUrl(), urlTemplateParams);
        client.close();
        try {
            return this.doRequest(HttpPut.class, requestUrl, adminUser, adminPassword, requestParams);
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doPutRequest failed", error);
        }
    }

    protected HttpResponse doPutJsonRequest(String adminUser, String adminPassword, int expectedStatusCode, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        return this.doPutJsonRequest(adminUser, adminPassword, expectedStatusCode, client.getApiUrl(), requestParams, urlTemplate, urlTemplateParams);
    }

    private HttpResponse doPutJsonRequest(String adminUser, String adminPassword, int expectedStatusCode, String urlStart, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        String requestUrl = this.formatRequestUrl(urlStart, urlTemplate, urlTemplateParams);
        try {
            HttpResponse httpResponse = this.doRequestJson(HttpPut.class, requestUrl, adminUser, adminPassword, requestParams);
            AssertJUnit.assertEquals((String)("PUT request to " + requestUrl + " was not successful."), (int)expectedStatusCode, (int)httpResponse.getStatusLine().getStatusCode());
            return httpResponse;
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doPutRequest failed", error);
        }
    }

    private String formatRequestUrl(String urlStart, String urlTemplate, String[] urlTemplateParams) {
        if (urlTemplateParams.length == 1) {
            return MessageFormat.format(urlTemplate, urlStart, urlTemplateParams[0]);
        }
        return MessageFormat.format(urlTemplate, urlStart, urlTemplateParams);
    }

    protected JSONObject doPostRequest(String adminUser, String adminPassword, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String requestUrl = MessageFormat.format(urlTemplate, client.getApiUrl(), urlTemplateParams);
        client.close();
        try {
            return this.doRequest(HttpPost.class, requestUrl, adminUser, adminPassword, requestParams);
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doPostRequest failed", error);
        }
    }

    protected HttpResponse doPostJsonRequest(String adminUser, String adminPassword, int expectedStatusCode, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        return this.doPostJsonRequest(adminUser, adminPassword, expectedStatusCode, client.getApiUrl(), requestParams, urlTemplate, urlTemplateParams);
    }

    protected HttpResponse doSlingshotPostJsonRequest(String adminUser, String adminPassword, int expectedStatusCode, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        return this.doPostJsonRequest(adminUser, adminPassword, expectedStatusCode, client.getAlfrescoUrl() + SLINGSHOT_PREFIX, requestParams, urlTemplate, urlTemplateParams);
    }

    private HttpResponse doPostJsonRequest(String adminUser, String adminPassword, int expectedStatusCode, String urlStart, JSONObject requestParams, String urlTemplate, String ... urlTemplateParams) {
        String requestUrl = this.formatRequestUrl(urlStart, urlTemplate, urlTemplateParams);
        try {
            HttpResponse httpResponse = this.doRequestJson(HttpPost.class, requestUrl, adminUser, adminPassword, requestParams);
            AssertJUnit.assertEquals((String)("POST request to " + requestUrl + " was not successful."), (int)expectedStatusCode, (int)httpResponse.getStatusLine().getStatusCode());
            return httpResponse;
        }
        catch (IllegalAccessException | InstantiationException error) {
            throw new IllegalArgumentException("doPostRequest failed", error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends HttpRequestBase> JSONObject doRequest(Class<T> requestType, String requestUrl, String adminUser, String adminPassword, JSONObject requestParams) throws InstantiationException, IllegalAccessException {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        HttpRequestBase request = (HttpRequestBase)requestType.newInstance();
        JSONObject responseBody = null;
        JSONObject returnValues = null;
        try {
            request.setURI(new URI(requestUrl));
            if (requestParams != null && request instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new StringEntity(requestParams.toString()));
            }
            LOGGER.info("Sending {} request to {}", (Object)requestType.getSimpleName(), (Object)requestUrl);
            LOGGER.info("Request body: {}", (Object)requestParams);
            HttpResponse response = client.execute(adminUser, adminPassword, request);
            LOGGER.info("Response: {}", (Object)response.getStatusLine());
            try {
                responseBody = new JSONObject(EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (JSONException error) {
                LOGGER.error("Converting message body to JSON failed. Body: {}", (Object)responseBody, (Object)error);
            }
            catch (IOException | ParseException error) {
                LOGGER.error("Parsing message body failed.", error);
            }
            switch (response.getStatusLine().getStatusCode()) {
                case 200: 
                case 201: {
                    if (responseBody == null) return returnValues;
                    returnValues = responseBody;
                    return returnValues;
                }
                case 500: {
                    if (responseBody == null || !responseBody.has(EXCEPTION_KEY)) return returnValues;
                    LOGGER.error("Request failed with error message: {}", (Object)responseBody.getString(MESSAGE_KEY));
                    returnValues = responseBody;
                    return returnValues;
                }
                case 400: 
                case 422: {
                    if (responseBody == null || !responseBody.has(EXCEPTION_KEY)) return returnValues;
                    LOGGER.error("Request failed: {}", (Object)responseBody.getString(EXCEPTION_KEY));
                    returnValues = responseBody;
                    return returnValues;
                }
                default: {
                    LOGGER.error("Request returned unexpected HTTP status {}", (Object)response.getStatusLine().getStatusCode());
                    return returnValues;
                }
            }
        }
        catch (JSONException error) {
            LOGGER.error("Unable to extract response parameter", (Throwable)error);
            return returnValues;
        }
        catch (UnsupportedEncodingException | URISyntaxException error1) {
            LOGGER.error("Unable to construct request", (Throwable)error1);
            return returnValues;
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends HttpRequestBase> HttpResponse doRequestJson(Class<T> requestType, String requestUrl, String adminUser, String adminPassword, JSONObject requestParams) throws InstantiationException, IllegalAccessException {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        HttpRequestBase request = (HttpRequestBase)requestType.newInstance();
        try {
            request.setURI(new URI(requestUrl));
            request.setHeader("Content-Type", "application/json");
            if (requestParams != null && request instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)new StringEntity(requestParams.toString()));
            }
            LOGGER.info("Sending {} request to {}", (Object)requestType.getSimpleName(), (Object)requestUrl);
            LOGGER.info("Request body: {}", (Object)requestParams);
            HttpResponse httpResponse = client.execute(adminUser, adminPassword, request);
            LOGGER.info("Response: {}", (Object)httpResponse.getStatusLine());
            HttpResponse httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (UnsupportedEncodingException | URISyntaxException error1) {
            LOGGER.error("Unable to construct request", (Throwable)error1);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
            client.close();
        }
        return null;
    }

    public <K extends Enum<?>> String getPropertyValue(Map<K, String> properties, Enum<?> property) {
        String value = properties.get(property);
        if (value == null) {
            return "";
        }
        return value;
    }

    protected <K extends Enum<?>> JSONObject addPropertyToRequest(JSONObject requestParams, String propertyRequestValue, Map<K, String> itemProperties, Enum<?> property) throws JSONException {
        String propertyValue = this.getPropertyValue(itemProperties, property);
        if (!propertyValue.equals("")) {
            requestParams.put(propertyRequestValue, (Object)propertyValue);
        }
        return requestParams;
    }

    protected void deleteItem(String username, String password, String itemPath) {
        CmisObject container = this.getObjectByPath(username, password, FILE_PLAN_PATH + itemPath);
        if (container != null) {
            container.delete();
        }
        AssertJUnit.assertNull((String)("Could not delete " + itemPath), (Object)this.getObjectByPath(username, password, itemPath));
    }

    public static String getNodeRefSpacesStore() {
        return NODE_REF_WORKSPACE_SPACES_STORE;
    }

    public static String getFilePlanPath() {
        return FILE_PLAN_PATH;
    }

    public static enum PermissionType {
        SET_READ,
        REMOVE_READ,
        SET_READ_AND_FILE,
        REMOVE_READ_AND_FILE;

    }

    public static enum RM_ACTIONS {
        EDIT_DISPOSITION_DATE("editDispositionActionAsOfDate"),
        END_RETENTION("retain"),
        CUT_OFF("cutoff"),
        UNDO_CUT_OFF("undoCutoff"),
        TRANSFER("transfer"),
        COMPLETE_EVENT("completeEvent"),
        UNDO_EVENT("undoEvent"),
        DESTROY("destroy");

        String action;

        private RM_ACTIONS(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }
    }

    public static enum RETENTION_SCHEDULE {
        NAME,
        DESCRIPTION,
        RETENTION_AUTHORITY,
        RETENTION_INSTRUCTIONS,
        RETENTION_PERIOD,
        RETENTION_LOCATION,
        RETENTION_PERIOD_PROPERTY,
        RETENTION_GHOST,
        RETENTION_ELIGIBLE_FIRST_EVENT,
        RETENTION_EVENTS,
        COMBINE_DISPOSITION_STEP_CONDITIONS;

    }

    public static enum RMProperty {
        NAME,
        TITLE,
        CONTENT,
        DESCRIPTION,
        AUTHOR,
        PHYSICAL_SIZE,
        NUMBER_OF_COPIES,
        STORAGE_LOCATION,
        SHELF,
        BOX,
        FILE,
        ORIGINATOR,
        ORIGINATING_ORGANIZATION,
        PUBLICATION_DATE;

    }
}

