/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.v0;

import java.text.MessageFormat;
import org.alfresco.rest.core.v0.BaseAPI;
import org.alfresco.rest.rm.community.model.custom.CustomDefinitions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.testng.AssertJUnit;

@Component
public class CustomDefinitionsAPI
extends BaseAPI {
    private static final String CUSTOM_REFERENCE_API_ENDPOINT = "{0}rma/admin/customreferencedefinitions";
    private static final String CREATE_RELATIONSHIP_API_ENDPOINT = "{0}node/{1}/customreferences";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomDefinitionsAPI.class);

    public String getCustomReferenceId(String adminUser, String adminPassword, String customDefinition) {
        JSONObject getResponse = this.doGetRequest(adminUser, adminPassword, CUSTOM_REFERENCE_API_ENDPOINT, new String[0]);
        if (getResponse != null) {
            try {
                JSONArray customDefinitions = getResponse.getJSONObject("data").getJSONArray("customReferences");
                for (int i = 0; i < customDefinitions.length(); ++i) {
                    JSONObject item = customDefinitions.getJSONObject(i);
                    boolean hasSource = customDefinition.equalsIgnoreCase(item.has("source") ? item.getString("source") : null);
                    boolean hasTarget = customDefinition.equalsIgnoreCase(item.has("target") ? item.getString("target") : null);
                    boolean hasLabel = customDefinition.equalsIgnoreCase(item.has("label") ? item.getString("label") : null);
                    if (!hasSource && !hasTarget && !hasLabel) continue;
                    return item.getString("refId");
                }
            }
            catch (JSONException error) {
                LOGGER.error("Unable to get the refId for the custom reference definition {}", (Object)customDefinition);
            }
        }
        return null;
    }

    public void createRelationship(String adminUser, String adminPassword, String recordNodeIdFrom, String recordNodeIdTo, CustomDefinitions relationshipType) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("toNode", (Object)("workspace://SpacesStore/" + recordNodeIdTo));
        requestParams.put("refId", (Object)this.getCustomReferenceId(adminUser, adminPassword, relationshipType.getDefinition()));
        JSONObject setRelationshipStatus = this.doPostRequest(adminUser, adminPassword, requestParams, MessageFormat.format(CREATE_RELATIONSHIP_API_ENDPOINT, "{0}", "workspace/SpacesStore/" + recordNodeIdFrom), new String[0]);
        boolean success = setRelationshipStatus != null && setRelationshipStatus.getBoolean("success");
        AssertJUnit.assertTrue((String)("Creating relationship from " + recordNodeIdFrom + " to " + recordNodeIdTo + " failed."), (boolean)success);
    }
}

