/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeclareDocsAsRecordsOnUpdateRuleNewVersionTests
extends BaseRMRestTest {
    @Autowired
    private DataSite dataSite;
    private SiteModel publicSite;
    private RecordCategory recordCategory;
    @Autowired
    private RulesAPI rulesAPI;
    @Autowired
    protected DataContent dataContent;
    @Autowired
    protected DataUserAIS dataUser;
    private static final String title = "Rule to convert document as record";

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
    }

    @Test
    @AlfrescoTest(jira="RM-1521")
    public void declareDocsAsRecordsOnUpdateRuleNewVersion() {
        Step.STEP((String)"Create test collaboration site to store documents in.");
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        Step.STEP((String)"Create a record folder with a DECLARE_AS_RECORD");
        RecordCategoryChild folderWithRule = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).actions(Collections.singletonList(ActionsOnRule.DECLARE_AS_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + folderWithRule.getId(), ruleDefinition);
        Step.STEP((String)"Create a document in the collaboration site");
        FileModel testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.assertStatusCode(HttpStatus.CREATED);
        UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
        List matchingRecords = unfiledContainersAPI.getUnfiledContainerChildren("-unfiled-").getEntries().stream().filter(e -> e.getEntry().getId().equals(testFile.getNodeRefWithoutVersion())).collect(Collectors.toList());
        this.deleteRecordCategory(this.recordCategory.getId());
        Step.STEP((String)"Delete the record.");
        this.dataSite.deleteSite(this.publicSite);
    }

    @Override
    protected DataUserAIS getDataUser() {
        return this.dataUser;
    }
}

