/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import jakarta.annotation.Resource;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.requests.search.SearchAPI;
import org.alfresco.rest.rm.community.requests.gscore.GSCoreAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.ActionsExecutionAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.FilePlanAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.FilesAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RMSiteAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RMUserAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.TransferAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.TransferContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.utility.data.DataUserAIS;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class RestAPIFactory {
    @Autowired
    private DataUserAIS dataUser;
    @Resource(name="RMRestWrapper")
    private RMRestWrapper rmRestWrapper;

    private GSCoreAPI getGSCoreAPI(UserModel userModel) {
        this.getRmRestWrapper().authenticateUser(userModel != null ? userModel : this.getDataUser().getAdminUser());
        return this.getRmRestWrapper().withGSCoreAPI();
    }

    private RestCoreAPI getCoreAPI(UserModel userModel) {
        this.getRmRestWrapper().authenticateUser(userModel != null ? userModel : this.getDataUser().getAdminUser());
        return this.getRmRestWrapper().withCoreAPI();
    }

    public SearchAPI getSearchAPI(UserModel userModel) {
        this.getRmRestWrapper().authenticateUser(userModel != null ? userModel : this.getDataUser().getAdminUser());
        return this.getRmRestWrapper().withSearchAPI();
    }

    public SearchAPI getSearchAPI() {
        return this.getSearchAPI(null);
    }

    public Node getNodeAPI(RepoTestModel model) throws RuntimeException {
        try {
            return this.getCoreAPI(null).usingNode(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load nodeAPI.", e);
        }
    }

    public Node getNodeAPI(UserModel userModel, RepoTestModel model) throws RuntimeException {
        try {
            return this.getCoreAPI(userModel).usingNode(model);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load nodeAPI.", e);
        }
    }

    public RMSiteAPI getRMSiteAPI() {
        return this.getGSCoreAPI(null).usingRMSite();
    }

    public RMSiteAPI getRMSiteAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingRMSite();
    }

    public FilePlanAPI getFilePlansAPI() {
        return this.getGSCoreAPI(null).usingFilePlans();
    }

    public FilePlanAPI getFilePlansAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingFilePlans();
    }

    public RecordCategoryAPI getRecordCategoryAPI() {
        return this.getGSCoreAPI(null).usingRecordCategory();
    }

    public RecordCategoryAPI getRecordCategoryAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingRecordCategory();
    }

    public RecordFolderAPI getRecordFolderAPI() {
        return this.getGSCoreAPI(null).usingRecordFolder();
    }

    public RecordFolderAPI getRecordFolderAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingRecordFolder();
    }

    public RecordsAPI getRecordsAPI() {
        return this.getGSCoreAPI(null).usingRecords();
    }

    public RecordsAPI getRecordsAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingRecords();
    }

    public FilesAPI getFilesAPI() {
        return this.getGSCoreAPI(null).usingFiles();
    }

    public FilesAPI getFilesAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingFiles();
    }

    public TransferContainerAPI getTransferContainerAPI() {
        return this.getGSCoreAPI(null).usingTransferContainer();
    }

    public TransferContainerAPI getTransferContainerAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingTransferContainer();
    }

    public TransferAPI getTransferAPI() {
        return this.getGSCoreAPI(null).usingTransfer();
    }

    public TransferAPI getTransferAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingTransfer();
    }

    public RMUserAPI getRMUserAPI() {
        return this.getGSCoreAPI(null).usingRMUser();
    }

    public RMUserAPI getRMUserAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingRMUser();
    }

    public UnfiledContainerAPI getUnfiledContainersAPI() {
        return this.getGSCoreAPI(null).usingUnfiledContainers();
    }

    public UnfiledContainerAPI getUnfiledContainersAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingUnfiledContainers();
    }

    public UnfiledRecordFolderAPI getUnfiledRecordFoldersAPI() {
        return this.getGSCoreAPI(null).usingUnfiledRecordFolder();
    }

    public UnfiledRecordFolderAPI getUnfiledRecordFoldersAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingUnfiledRecordFolder();
    }

    public ActionsExecutionAPI getActionsAPI(UserModel userModel) {
        return this.getGSCoreAPI(userModel).usingActionsExecutionsAPI();
    }

    public ActionsExecutionAPI getActionsAPI() {
        return this.getGSCoreAPI(null).usingActionsExecutionsAPI();
    }

    protected DataUserAIS getDataUser() {
        return this.dataUser;
    }

    public RMRestWrapper getRmRestWrapper() {
        return this.rmRestWrapper;
    }

    public void setRmRestWrapper(RMRestWrapper rmRestWrapper) {
        this.rmRestWrapper = rmRestWrapper;
    }
}

