/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.common.ReviewPeriod;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolder;
import org.alfresco.rest.rm.community.model.recordfolder.RecordFolderProperties;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.smoke.CreateCategoriesTests;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CreateFoldersTests
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateCategoriesTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private RecordCategory Category1;
    private RecordCategory Category2;
    private RecordCategoryChild recordCategoryChild;

    @BeforeClass(alwaysRun=true)
    public void preconditionForCreateFolderTests() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create two category");
        this.Category1 = this.createRootCategory(RandomData.getRandomName((String)"Category1"));
        this.Category2 = this.createRootCategory(RandomData.getRandomName((String)"Category2"));
        this.recordCategoryChild = this.createRecordFolder(this.Category1.getId(), RandomData.getRandomName((String)"recFolder"));
    }

    @Test
    @AlfrescoTest(jira="RM-2757")
    public void createFolders() throws Exception {
        String folderDescription = "The folder description is updated" + RandomData.getRandomAlphanumeric();
        String folderName = "The folder name is updated" + RandomData.getRandomAlphanumeric();
        String folderTitle = "Update title " + RandomData.getRandomAlphanumeric();
        String location = "Location " + RandomData.getRandomAlphanumeric();
        RecordFolder recordFolder = RecordFolder.builder().name(folderName).properties(RecordFolderProperties.builder().title(folderTitle).description(folderDescription).vitalRecordIndicator(Boolean.valueOf(true)).reviewPeriod(new ReviewPeriod("month", "1")).location(location).build()).build();
        RecordFolder updatedRecordFolder = this.getRestAPIFactory().getRecordFolderAPI().updateRecordFolder(recordFolder, this.recordCategoryChild.getId());
        this.assertStatusCode(HttpStatus.OK);
        Step.STEP((String)"copy updated Record in category 1 and category 2");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(updatedRecordFolder.getId())).copy(CoreUtil.createBodyForMoveCopy(this.Category1.getId()));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(updatedRecordFolder.getId())).copy(CoreUtil.createBodyForMoveCopy(this.Category2.getId()));
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String recordFolderId = updatedRecordFolder.getId();
        recordFolderAPI.deleteRecordFolder(recordFolderId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        recordFolderAPI.getRecordFolder(recordFolderId);
        this.assertStatusCode(HttpStatus.NOT_FOUND);
        Step.STEP((String)"move updated Record from category 1 to category 2");
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(updatedRecordFolder.getId())).move(CoreUtil.createBodyForMoveCopy(this.Category2.getId()));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(this.Category2.getId())).move(CoreUtil.createBodyForMoveCopy(this.Category1.getId()));
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        String recordCategoryId = this.Category1.getId();
        recordCategoryAPI.deleteRecordCategory(recordCategoryId);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }
}

