/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordcategories;

import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class AutomaticDispositionTest
extends BaseRMRestTest {
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    private RecordCategory categoryWithRSOnRecords;

    @Test(enabled=false)
    public void testAutomaticCutOff() throws Exception {
        Step.STEP((String)"Create record category with retention schedule and apply it to records.");
        this.categoryWithRSOnRecords = this.createRootCategory(RandomData.getRandomName((String)"categoryWithRSOnRecords"));
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.categoryWithRSOnRecords.getName(), Boolean.valueOf(true));
        Step.STEP((String)"Add retention schedule cut off step with immediate period.");
        this.dispositionScheduleService.addCutOffImmediatelyStep(this.categoryWithRSOnRecords.getName());
        Step.STEP((String)"Create a record folder with a record");
        RecordCategoryChild recordFolder = this.createRecordFolder(this.categoryWithRSOnRecords.getId(), RandomData.getRandomName((String)"recordFolder"));
        Record record = this.createElectronicRecord(recordFolder.getId(), RandomData.getRandomName((String)"elRecord"));
        Step.STEP((String)"Complete the record and wait upon to 5 minutes for automatic job to execute");
        this.completeRecord(record.getId());
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        List aspects = recordsAPI.getRecord(record.getId()).getAspectNames();
        for (int count = 0; !aspects.contains("rma:cutOff") && count < 30; ++count) {
            Thread.sleep(10000L);
            aspects = recordsAPI.getRecord(record.getId()).getAspectNames();
        }
        Assert.assertTrue((boolean)aspects.contains("rma:cutOff"), (String)"Record should now be cut off");
    }

    @AfterClass(alwaysRun=true)
    public void deleteCategory() {
        this.deleteRecordCategory(this.categoryWithRSOnRecords.getId());
    }
}

