/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.io.IOException;
import java.time.Instant;
import org.alfresco.rest.core.v0.RMEvents;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.recordcategory.RetentionPeriodProperty;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RecordFoldersAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.service.DispositionScheduleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.report.log.Step;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

public class RecordsDispositionScheduleTests
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RecordFoldersAPI recordFoldersAPI;
    @Autowired
    private DispositionScheduleService dispositionScheduleService;
    private RecordCategory Category1;
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(RecordsDispositionScheduleTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private final String recordsCategory = this.TEST_PREFIX + "RM-2801 category";
    private final String folderDisposition = this.TEST_PREFIX + "RM-2801 folder";

    @Test
    @AlfrescoTest(jira="RM-2801")
    public void recordsDispositionScheduleWithoutGhosting() {
        this.createTestPrecondition(this.recordsCategory);
        this.dispositionScheduleService.createCategoryRetentionSchedule(this.Category1.getName(), Boolean.valueOf(true));
        this.dispositionScheduleService.addCutOffImmediatelyStep(this.Category1.getName());
        this.dispositionScheduleService.addTransferAfterEventStep(this.Category1.getName(), "transferred records", "all_allowances_granted_are_terminated");
        this.dispositionScheduleService.addDestroyWithoutGhostingAfterPeriodStep(this.Category1.getName(), "day|1", RetentionPeriodProperty.CUT_OFF_DATE);
        RecordCategoryChild FOLDER_DESTROY = this.createFolder(this.getAdminUser(), this.Category1.getId(), this.folderDisposition);
        String electronicRecord = "RM-2801 electronic record";
        Record elRecord = this.createElectronicRecord(FOLDER_DESTROY.getId(), electronicRecord);
        String nonElectronicRecord = "RM-2801 non-electronic record";
        Record nonElRecord = this.createNonElectronicRecord(FOLDER_DESTROY.getId(), nonElectronicRecord);
        String nonElRecordName = this.recordsAPI.getRecordFullName(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.folderDisposition, nonElectronicRecord);
        String elRecordName = this.recordsAPI.getRecordFullName(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.folderDisposition, electronicRecord);
        this.completeRecord(elRecord.getId());
        this.completeRecord(nonElRecord.getId());
        String nonElRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecordName, "/" + this.Category1.getName() + "/" + this.folderDisposition);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), nonElRecordNameNodeRef);
        String elRecordNameNodeRef = this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordName, "/" + this.Category1.getName() + "/" + this.folderDisposition);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"cutoff"), elRecordNameNodeRef);
        this.rmRolesAndActionsAPI.completeEvent(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), nonElRecordName, RMEvents.ALL_ALLOWANCES_GRANTED_ARE_TERMINATED, Instant.now());
        this.rmRolesAndActionsAPI.completeEvent(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), elRecordName, RMEvents.ALL_ALLOWANCES_GRANTED_ARE_TERMINATED, Instant.now());
        HttpResponse nonElRecordNameHttpResponse = this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transfer"), this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), nonElRecordName, "/" + this.Category1.getName() + "/" + this.folderDisposition));
        String nonElRecordNameTransferId = this.getTransferId(nonElRecordNameHttpResponse, nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transferComplete"), nonElRecordNameTransferId);
        HttpResponse elRecordNameHttpResponse = this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transfer"), this.recordsAPI.getRecordNodeRef(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), elRecordName, "/" + this.Category1.getName() + "/" + this.folderDisposition));
        String elRecordNameTransferId = this.getTransferId(elRecordNameHttpResponse, elRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"transferComplete"), elRecordNameTransferId);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.editDispositionDateJson(), elRecordNameNodeRef);
        Utility.waitToLoopTime((int)5, (String[])new String[]{"Waiting for Edit Disposition to be processed"});
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"destroy"), nonElRecordNameNodeRef);
        this.recordFoldersAPI.postRecordAction(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), new JSONObject().put("name", (Object)"destroy"), elRecordNameNodeRef);
        this.deleteRecordCategory(this.Category1.getId());
    }

    private void createTestPrecondition(String categoryName) {
        this.createRMSiteIfNotExists();
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getUsername(), ((DataUser)this.getDataUser().usingAdmin()).getAdminUser().getPassword(), this.RM_ADMIN, "password", "Administrator");
        Step.STEP((String)"Create two category");
        this.Category1 = this.createRootCategory(categoryName, "Title");
    }

    private String getTransferId(HttpResponse httpResponse, String nodeRef) {
        HttpEntity entity = httpResponse.getEntity();
        String responseString = null;
        try {
            responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject result = new JSONObject(responseString);
        return result.getJSONObject("results").get(nodeRef).toString();
    }
}

