/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.hold;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldDeletionReason;
import org.alfresco.utility.data.RandomData;
import org.junit.Assert;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class HoldsTests
extends BaseRMRestTest {
    private final List<String> nodeRefs = new ArrayList<String>();

    @Test
    public void testGetHold() {
        String holdName = "Hold" + RandomData.getRandomAlphanumeric();
        String holdDescription = "Description" + RandomData.getRandomAlphanumeric();
        String holdReason = "Reason" + RandomData.getRandomAlphanumeric();
        Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
        Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
        Hold receivedHold = this.getRestAPIFactory().getHoldsAPI().getHold(createdHold.getId());
        this.nodeRefs.add(receivedHold.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((Object)receivedHold.getName(), (Object)holdName);
        Assert.assertEquals((Object)receivedHold.getDescription(), (Object)holdDescription);
        Assert.assertEquals((Object)receivedHold.getReason(), (Object)holdReason);
        Assert.assertNotNull((Object)receivedHold.getId());
    }

    @Test
    public void testUpdateHold() {
        String holdName = "Hold" + RandomData.getRandomAlphanumeric();
        String holdDescription = "Description" + RandomData.getRandomAlphanumeric();
        String holdReason = "Reason" + RandomData.getRandomAlphanumeric();
        Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
        Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
        this.nodeRefs.add(createdHold.getId());
        Hold holdModel = Hold.builder().name("Updated" + holdName).description("Updated" + holdDescription).reason("Updated" + holdReason).build();
        Hold updatedHold = this.getRestAPIFactory().getHoldsAPI().updateHold(holdModel, createdHold.getId());
        this.assertStatusCode(HttpStatus.OK);
        Assert.assertEquals((Object)updatedHold.getName(), (Object)("Updated" + holdName));
        Assert.assertEquals((Object)updatedHold.getDescription(), (Object)("Updated" + holdDescription));
        Assert.assertEquals((Object)updatedHold.getReason(), (Object)("Updated" + holdReason));
        Assert.assertNotNull((Object)updatedHold.getId());
    }

    @Test
    public void testDeleteHold() {
        String holdName = "Hold" + RandomData.getRandomAlphanumeric();
        String holdDescription = "Description" + RandomData.getRandomAlphanumeric();
        String holdReason = "Reason" + RandomData.getRandomAlphanumeric();
        Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
        Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
        this.nodeRefs.add(createdHold.getId());
        this.getRestAPIFactory().getHoldsAPI().deleteHold(createdHold.getId());
        this.assertStatusCode(HttpStatus.NO_CONTENT);
        this.getRestAPIFactory().getHoldsAPI().getHold(createdHold.getId());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @Test
    public void testDeleteHoldWithReason() {
        String holdName = "Hold" + RandomData.getRandomAlphanumeric();
        String holdDescription = "Description" + RandomData.getRandomAlphanumeric();
        String holdReason = "Reason" + RandomData.getRandomAlphanumeric();
        Hold hold = Hold.builder().name(holdName).description(holdDescription).reason(holdReason).build();
        Hold createdHold = this.getRestAPIFactory().getFilePlansAPI().createHold(hold, "-filePlan-");
        this.nodeRefs.add(createdHold.getId());
        this.getRestAPIFactory().getHoldsAPI().deleteHoldWithReason(HoldDeletionReason.builder().reason("Example reason").build(), createdHold.getId());
        this.assertStatusCode(HttpStatus.OK);
        this.getRestAPIFactory().getHoldsAPI().getHold(createdHold.getId());
        this.assertStatusCode(HttpStatus.NOT_FOUND);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpHoldsTests() {
        this.nodeRefs.forEach(nodeRef -> this.getRestAPIFactory().getHoldsAPI(this.getAdminUser()).deleteHold(nodeRef));
    }
}

