/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.smoke;

import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.smoke.CreateCategoriesTests;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class BasicRulesIntegrationTests
extends BaseRMRestTest {
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;
    private static final String title = "Rule to complete";
    private static final String description = "Rule to describe";
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CreateCategoriesTests.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    @Autowired
    private RulesAPI rulesAPI;

    @Test
    @AlfrescoTest(jira="RM-2794")
    public void basicRulesIntegration() {
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create RM Admin user");
        this.rmRolesAndActionsAPI.createUserAndAssignToRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), this.RM_ADMIN, this.getAdminUser().getPassword(), "Administrator");
        Step.STEP((String)"Create record categories and record folders");
        RecordCategory Category2 = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        String recordFolder1 = this.createRecordFolder(Category2.getId(), RandomData.getRandomName((String)"recFolder")).getId();
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description1").applyToChildren(true).title(title).actions(Collections.singletonList(ActionsOnRule.COMPLETE_RECORD.getActionValue()));
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + Category2.getId(), ruleDefinition);
        RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
        String electronicRecordId1 = this.createElectronicRecord(recordFolder1, TestData.ELECTRONIC_RECORD_NAME).getId();
        String electronicRecordId2 = this.createElectronicRecord(recordFolder1, TestData.ELECTRONIC_RECORD_NAME).getId();
        this.assertStatusCode(HttpStatus.CREATED);
        this.rulesAPI.updateRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + Category2.getId(), ruleDefinition.description("description").id(description));
        this.deleteRecordCategory(Category2.getId());
        this.rulesAPI.deleteAllRulesOnContainer(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + Category2.getId());
    }
}

