/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.recordfolders;

import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordFolderAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledContainerAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.UnfiledRecordFolderAPI;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.alfresco.rest.rm.community.utils.FilePlanComponentsUtil;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.report.Bug;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ElectronicRecordTests
extends BaseRMRestTest {
    @DataProvider(name="invalidParentContainers")
    public Object[][] invalidParentContainers() {
        return new String[][]{{this.createCategoryFolderInFilePlan().getParentId()}, {"-filePlan-"}, {"-transfers-"}};
    }

    @Test(dataProvider="invalidParentContainers", description="Electronic records can't be created in invalid parent containers")
    public void cantCreateElectronicRecordsInInvalidContainers(String container) {
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), container, FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(description="Electronic record can't be created in closed record folder")
    public void cantCreateElectronicRecordInClosedFolder() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        Assert.assertFalse((boolean)recordFolder.getProperties().getIsClosed());
        this.closeFolder(recordFolder.getId());
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(FilePlanComponentsUtil.createElectronicRecordModel(), recordFolder.getId(), FilePlanComponentsUtil.getFile("money.JPG"));
        this.assertStatusCode(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(dataProvider="validRootContainers", description="Electronic record can only be created if all mandatory properties are given")
    public void canCreateElectronicRecordOnlyWithMandatoryProperties(String folderId, String type) throws Exception {
        this.logger.info((Object)("Root container:\n" + PojoUtility.toJson((Object)folderId)));
        if ("rma:recordFolder".equalsIgnoreCase(type)) {
            RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
            Assert.assertFalse((boolean)recordFolderAPI.getRecordFolder(folderId).getProperties().getIsClosed());
            Record recordModel = Record.builder().nodeType("cm:content").build();
            recordFolderAPI.createRecord(recordModel, folderId);
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().nodeType("cm:content").build();
            unfiledContainersAPI.createUnfiledContainerChild(recordModel, folderId);
        } else if ("rma:unfiledRecordFolder".equalsIgnoreCase(type)) {
            UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().nodeType("cm:content").build();
            unfiledRecordFoldersAPI.createUnfiledRecordFolderChild(recordModel, folderId);
        } else {
            throw new Exception("Unsuported type = " + type);
        }
        this.assertStatusCode(HttpStatus.BAD_REQUEST);
    }

    @Test(dataProvider="validRootContainers", description="Electronic records can be created in record folders, unfiled record folders or unfiled record folder root")
    public void canCreateElectronicRecordsInValidContainers(String folderId, String type) throws Exception {
        String expectedName;
        String newRecordId;
        if ("rma:recordFolder".equalsIgnoreCase(type)) {
            RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
            recordModel = FilePlanComponentsUtil.createElectronicRecordModel();
            newRecordId = recordFolderAPI.createRecord(recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
            expectedName = recordModel.getName();
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
            recordModel = FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel();
            newRecordId = unfiledContainersAPI.uploadRecord((UnfiledContainerChild)recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
            expectedName = recordModel.getName();
        } else if ("rma:unfiledRecordFolder".equalsIgnoreCase(type)) {
            UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
            recordModel = FilePlanComponentsUtil.createElectronicUnfiledContainerChildModel();
            newRecordId = unfiledRecordFoldersAPI.uploadRecord((UnfiledContainerChild)recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
            expectedName = recordModel.getName();
        } else {
            throw new Exception("Unsuported type = " + type);
        }
        this.assertStatusCode(HttpStatus.CREATED);
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record record = recordsAPI.getRecord(newRecordId);
        String recordName = record.getName();
        Assert.assertTrue((boolean)recordName.startsWith(expectedName));
        Assert.assertTrue((boolean)recordName.contains(record.getProperties().getIdentifier()));
    }

    @Test(dataProvider="validRootContainers", description="Electronic records can be created in unfiled record folder or unfiled record root")
    public void recordNameDerivedFromFileName(String folderId, String type) throws Exception {
        String newRecordId;
        if ("rma:recordFolder".equalsIgnoreCase(type)) {
            Record recordModel = Record.builder().nodeType("cm:content").build();
            RecordFolderAPI recordFolderAPI = this.getRestAPIFactory().getRecordFolderAPI();
            newRecordId = recordFolderAPI.createRecord(recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
        } else if ("rma:unfiledRecordContainer".equalsIgnoreCase(type)) {
            UnfiledContainerAPI unfiledContainersAPI = this.getRestAPIFactory().getUnfiledContainersAPI();
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().nodeType("cm:content").build();
            newRecordId = unfiledContainersAPI.uploadRecord(recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
        } else if ("rma:unfiledRecordFolder".equalsIgnoreCase(type)) {
            UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
            UnfiledContainerChild recordModel = UnfiledContainerChild.builder().nodeType("cm:content").build();
            newRecordId = unfiledRecordFoldersAPI.uploadRecord(recordModel, folderId, FilePlanComponentsUtil.getFile("money.JPG")).getId();
        } else {
            throw new Exception("Unsuported type = " + type);
        }
        this.assertStatusCode(HttpStatus.CREATED);
        Record electronicRecord = this.getRestAPIFactory().getRecordsAPI().getRecord(newRecordId);
        Assert.assertTrue((boolean)electronicRecord.getName().startsWith("money.JPG".substring(0, "money.JPG".indexOf("."))));
        Assert.assertTrue((boolean)electronicRecord.getName().contains(electronicRecord.getProperties().getIdentifier()));
    }

    @Test
    @Bug(id="RM-4568")
    public void createElectronicRecordWithRelativePath() {
        String parentUbnfiledRecordFolderName = "ParentUnfiledRecordFolder" + RandomData.getRandomAlphanumeric();
        String unfiledRecordFolderPathEl1 = "UnfiledRecordFolderPathEl1" + RandomData.getRandomAlphanumeric();
        String unfiledRecordFolderPathEl2 = "UnfiledRecordFolderPathEl2" + RandomData.getRandomAlphanumeric();
        String unfiledRecordFolderPathEl3 = "UnfiledRecordFolderPathEl3" + RandomData.getRandomAlphanumeric();
        String parentUnfiledRecordFolderId = this.createUnfiledContainerChild("-unfiled-", parentUbnfiledRecordFolderName, "rma:unfiledRecordFolder").getId();
        String relativePath = unfiledRecordFolderPathEl1 + "/" + unfiledRecordFolderPathEl2 + "/" + unfiledRecordFolderPathEl3;
        UnfiledContainerChild unfiledContainerChildModel = UnfiledContainerChild.builder().name(TestData.ELECTRONIC_RECORD_NAME).nodeType("cm:content").relativePath(relativePath).build();
        UnfiledRecordFolderAPI unfiledRecordFoldersAPI = this.getRestAPIFactory().getUnfiledRecordFoldersAPI();
        UnfiledContainerChild recordCreated = unfiledRecordFoldersAPI.uploadRecord(unfiledContainerChildModel, parentUnfiledRecordFolderId, FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME));
        this.assertStatusCode(HttpStatus.CREATED);
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        Record record = recordsAPI.getRecord(recordCreated.getId());
        Assert.assertTrue((boolean)record.getName().startsWith(TestData.ELECTRONIC_RECORD_NAME));
        Assert.assertEquals((String)unfiledRecordFoldersAPI.getUnfiledRecordFolder(record.getParentId()).getName(), (String)unfiledRecordFolderPathEl3);
        String unfiledRecordFolderPathEl4 = "UnfiledRecordFolderPathEl4" + RandomData.getRandomAlphanumeric();
        relativePath = unfiledRecordFolderPathEl1 + "/" + unfiledRecordFolderPathEl4;
        unfiledContainerChildModel.setRelativePath(relativePath);
        recordCreated = unfiledRecordFoldersAPI.uploadRecord(unfiledContainerChildModel, parentUnfiledRecordFolderId, FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME));
        this.assertStatusCode(HttpStatus.CREATED);
        record = recordsAPI.getRecord(recordCreated.getId());
        Assert.assertTrue((boolean)record.getName().startsWith(TestData.ELECTRONIC_RECORD_NAME));
        Assert.assertTrue((boolean)unfiledRecordFoldersAPI.getUnfiledRecordFolder(record.getParentId()).getName().equals(unfiledRecordFolderPathEl4));
        unfiledContainerChildModel.setName(TestData.ELECTRONIC_RECORD_NAME + RandomData.getRandomAlphanumeric());
        recordCreated = unfiledRecordFoldersAPI.uploadRecord(unfiledContainerChildModel, parentUnfiledRecordFolderId, FilePlanComponentsUtil.createTempFile(TestData.ELECTRONIC_RECORD_NAME, TestData.ELECTRONIC_RECORD_NAME));
        this.assertStatusCode(HttpStatus.CREATED);
        record = recordsAPI.getRecord(recordCreated.getId());
        Assert.assertTrue((boolean)record.getName().startsWith(TestData.ELECTRONIC_RECORD_NAME));
        Assert.assertTrue((boolean)unfiledRecordFoldersAPI.getUnfiledRecordFolder(record.getParentId()).getName().equals(unfiledRecordFolderPathEl4));
    }

    @Test(description="Electronic records can be created in record folder with duplicate name")
    @Bug(id="RM-5116, RM-5012")
    public void canCreateElectronicRecordsWithDuplicateName() {
        RecordCategoryChild recordFolder = this.createCategoryFolderInFilePlan();
        Record recordModel = Record.builder().name("Record 1").nodeType("cm:content").build();
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(recordModel, recordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        this.getRestAPIFactory().getRecordFolderAPI().createRecord(recordModel, recordFolder.getId());
        this.assertStatusCode(HttpStatus.CREATED);
    }
}

