/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.rules;

import java.util.Collections;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordCategoryAPI;
import org.alfresco.rest.rm.community.requests.gscore.api.RecordsAPI;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.rm.community.utils.CoreUtil;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class CopyToRuleOnFoldersTest
extends BaseRMRestTest {
    private RecordCategory category;
    private RecordCategoryChild folder1;
    private RecordCategoryChild folder2;
    private static final String title = "Run in background";
    private final String TEST_PREFIX = CommonTestUtils.generateTestPrefix(CopyToRuleOnFoldersTest.class);
    private final String RM_ADMIN = this.TEST_PREFIX + "rm_admin";
    private final String electronicRecord = this.TEST_PREFIX + "record_electronic_for_copyTo";
    private final String nonElectronicRecord = this.TEST_PREFIX + "record_non_electronic_for_copyTo";
    @Autowired
    private RulesAPI rulesAPI;

    @Test
    @AlfrescoTest(jira="RM-2994")
    public void copyToRuleOnFoldersTest() {
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description1").runInBackground(true).title(title).actions(Collections.singletonList(ActionsOnRule.COPY_TO.getActionValue()));
        Step.STEP((String)"Create the RM site if doesn't exist");
        this.createRMSiteIfNotExists();
        Step.STEP((String)"Create record categories and record folders");
        this.category = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        String folder1 = this.createCategoryFolderInFilePlan().getId();
        String folder2 = this.createCategoryFolderInFilePlan().getId();
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + folder1, ruleDefinition);
        String electronicRecordId = this.createElectronicRecord(folder1, TestData.ELECTRONIC_RECORD_NAME).getId();
        this.assertStatusCode(HttpStatus.CREATED);
        String nonElectronicRecord = this.createElectronicRecord(folder1, TestData.NONELECTRONIC_RECORD_NAME).getId();
        this.assertStatusCode(HttpStatus.CREATED);
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(folder1)).copy(CoreUtil.createBodyForMoveCopy(this.category.getId()));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(this.electronicRecord)).move(CoreUtil.createBodyForMoveCopy(folder2));
        this.getRestAPIFactory().getNodeAPI((RepoTestModel)CoreUtil.toContentModel(nonElectronicRecord)).move(CoreUtil.createBodyForMoveCopy(folder2));
        RecordsAPI recordsAPI = this.getRestAPIFactory().getRecordsAPI();
        RecordCategoryAPI recordCategoryAPI = this.getRestAPIFactory().getRecordCategoryAPI();
        String recordCategoryId = this.category.getId();
        recordCategoryAPI.deleteRecordCategory(recordCategoryId);
        recordsAPI.deleteRecord(this.electronicRecord);
        recordsAPI.deleteRecord(nonElectronicRecord);
        this.assertStatusCode(HttpStatus.NO_CONTENT);
    }
}

