/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainer;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChild;
import org.alfresco.rest.rm.community.model.unfiledcontainer.UnfiledContainerChildCollection;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.alfresco.rest.rm.community.util.UnfiledContainerChildMixin;
import org.springframework.http.HttpMethod;
import org.testng.Assert;

public class UnfiledContainerAPI
extends RMModelRequest {
    public UnfiledContainerAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public UnfiledContainer getUnfiledContainer(String unfiledContainerId) {
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getUnfiledContainer(unfiledContainerId, "");
    }

    public UnfiledContainer getUnfiledContainer(String unfiledContainerId, String parameters) {
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getRmRestWrapper().processModel(UnfiledContainer.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"unfiled-containers/{unfiledContainerId}?{parameters}", (String[])new String[]{unfiledContainerId, parameters}));
    }

    public UnfiledContainerChildCollection getUnfiledContainerChildren(String unfiledContainerId) {
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getUnfiledContainerChildren(unfiledContainerId, "");
    }

    public UnfiledContainerChildCollection getUnfiledContainerChildren(String unfiledContainerId, String parameters) {
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getRmRestWrapper().processModels(UnfiledContainerChildCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"unfiled-containers/{unfiledContainerId}/children?{parameters}", (String[])new String[]{unfiledContainerId, parameters}));
    }

    public UnfiledContainerChild createUnfiledContainerChild(UnfiledContainerChild unfiledContainerChildModel, String unfiledContainerId) {
        ParameterCheck.mandatoryObject("unfiledContainerChildModel", (Object)unfiledContainerChildModel);
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.createUnfiledContainerChild(unfiledContainerChildModel, unfiledContainerId, "");
    }

    public UnfiledContainerChild createUnfiledContainerChild(UnfiledContainerChild unfiledContainerChildModel, String unfiledContainerId, String parameters) {
        ParameterCheck.mandatoryObject("unfiledContainerChildModel", (Object)unfiledContainerChildModel);
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getRmRestWrapper().processModel(UnfiledContainerChild.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)unfiledContainerChildModel), (String)"unfiled-containers/{unfiledContainerId}/children?{parameters}", (String[])new String[]{unfiledContainerId, parameters}));
    }

    public UnfiledContainerChild uploadRecord(UnfiledContainerChild unfiledContainerChildModel, String unfiledContainerId, File unfiledContainerChildContent) {
        JsonNode root;
        ParameterCheck.mandatoryObject("unfiledContainerChildModel", (Object)unfiledContainerChildModel);
        ParameterCheck.mandatoryObject("unfiledContainerChildContent", unfiledContainerChildContent);
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        if (!unfiledContainerChildModel.getNodeType().equals("cm:content")) {
            Assert.fail((String)"Only electronic records are supported");
        }
        RequestSpecBuilder builder = this.getRmRestWrapper().configureRequestSpec();
        try {
            root = new ObjectMapper().readTree(PojoUtility.toJson((Object)unfiledContainerChildModel, UnfiledContainerChild.class, UnfiledContainerChildMixin.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert model to JSON.", e);
        }
        Iterator fieldNames = root.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            builder.addMultiPart(fieldName, root.get(fieldName).asText(), ContentType.JSON.name());
        }
        builder.addMultiPart("filedata", unfiledContainerChildContent, ContentType.BINARY.name());
        return this.createUnfiledContainerChild(unfiledContainerChildModel, unfiledContainerId);
    }

    public UnfiledContainer updateUnfiledContainer(UnfiledContainer unfiledContainerModel, String unfiledContainerId) {
        ParameterCheck.mandatoryObject("unfiledContainerModel", (Object)unfiledContainerModel);
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.updateUnfiledContainer(unfiledContainerModel, unfiledContainerId, "");
    }

    public UnfiledContainer updateUnfiledContainer(UnfiledContainer unfiledContainerModel, String unfiledContainerId, String parameters) {
        ParameterCheck.mandatoryObject("unfiledContainerModel", (Object)unfiledContainerModel);
        ParameterCheck.mandatoryString("unfiledContainerId", unfiledContainerId);
        return this.getRmRestWrapper().processModel(UnfiledContainer.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)unfiledContainerModel), (String)"unfiled-containers/{unfiledContainerId}?{parameters}", (String[])new String[]{unfiledContainerId, parameters}));
    }
}

