/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.search;

import org.alfresco.dataprep.ContentActions;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.user.UserPermissions;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.service.RoleService;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CmisQueryTests
extends BaseRMRestTest {
    private static final String SEARCH_TERM = CommonTestUtils.generateTestPrefix(CmisQueryTests.class);
    private static final String sqlWithName = "SELECT cmis:name FROM cmis:document where CONTAINS('cmis:name:*" + SEARCH_TERM + "*')";
    private SiteModel collaborationSite;
    private UserModel nonRMUser;
    private UserModel rmUser;
    private RecordCategoryChild recordFolder;
    @Autowired
    private ContentActions contentActions;
    @Autowired
    private RoleService roleService;

    @BeforeClass(alwaysRun=true)
    public void setupCmisQuery() throws Exception {
        FileModel fileModel;
        Step.STEP((String)"Create a collaboration site");
        this.collaborationSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        Step.STEP((String)"Create 10 documents ending with SEARCH_TERM");
        int i = 0;
        while (++i <= 10) {
            fileModel = new FileModel(String.format("%s%s%s.%s", "Doc", i, SEARCH_TERM, FileType.TEXT_PLAIN.extension));
            ((DataContent)this.dataContent.usingAdmin().usingSite(this.collaborationSite)).createContent(fileModel);
        }
        Step.STEP((String)"Create a collaborator user for the collaboration site");
        this.nonRMUser = this.getDataUser().createRandomTestUser();
        this.getDataUser().addUserToSite(this.nonRMUser, this.collaborationSite, UserRole.SiteCollaborator);
        Step.STEP((String)"Create 10 documents and declare as records");
        i = 0;
        while (++i <= 10) {
            fileModel = new FileModel(String.format("%s%s%s.%s", "InPlace ", SEARCH_TERM, i, FileType.TEXT_PLAIN.extension));
            fileModel = ((DataContent)this.dataContent.usingUser(this.nonRMUser).usingSite(this.collaborationSite)).createContent(fileModel);
            this.getRestAPIFactory().getFilesAPI(this.nonRMUser).declareAsRecord(fileModel.getNodeRefWithoutVersion());
        }
        Step.STEP((String)"Create record folder and some records ");
        this.recordFolder = this.createCategoryFolderInFilePlan();
        i = 0;
        while (++i <= 10) {
            this.createElectronicRecord(this.recordFolder.getId(), String.format("%s%s%s.%s", "Record ", SEARCH_TERM, i, FileType.TEXT_PLAIN.extension));
        }
        Step.STEP((String)"Create an rm user with read permission over the category created and contributor role within the collaboration site");
        this.rmUser = this.roleService.createUserWithSiteRoleRMRoleAndPermission(this.collaborationSite, UserRole.SiteContributor, this.recordFolder.getParentId(), UserRoles.ROLE_RM_MANAGER, UserPermissions.PERMISSION_READ_RECORDS);
        Utility.sleep((int)5000, (int)80000, () -> {
            ItemIterable results = this.contentActions.getCMISSession(this.getAdminUser().getUsername(), this.getAdminUser().getPassword()).query(sqlWithName, false);
            AssertJUnit.assertEquals((String)("Total number of items is not 30, got  " + results.getTotalNumItems() + " total items"), (long)30L, (long)results.getTotalNumItems());
        });
    }

    @Test
    @AlfrescoTest(jira="MNT-19442")
    public void getAllDocumentsNamesCmisQuery() {
        String cq = "SELECT cmis:name FROM cmis:document";
        ItemIterable results = this.contentActions.getCMISSession(this.getAdminUser().getUsername(), this.getAdminUser().getPassword()).query(cq, false);
        AssertJUnit.assertTrue((String)"Has more items not true.", (boolean)results.getHasMoreItems());
        AssertJUnit.assertTrue((String)("Total number of items is not greater than 100. Total number of items received" + results.getTotalNumItems()), (results.getTotalNumItems() > 100L ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)("Expected 100 items per page and got " + results.getPageNumItems() + " per page."), (long)100L, (long)results.getPageNumItems());
    }

    @Test
    @AlfrescoTest(jira="MNT-19442")
    public void getDocumentsWithSpecificNamesCmisQuery() {
        ItemIterable results = this.contentActions.getCMISSession(this.nonRMUser.getUsername(), this.nonRMUser.getPassword()).query(sqlWithName, false);
        AssertJUnit.assertEquals((String)("Total number of items is not 20, got  " + results.getTotalNumItems() + " total items"), (long)20L, (long)results.getTotalNumItems());
        AssertJUnit.assertFalse((String)"Has more items not false.", (boolean)results.getHasMoreItems());
        AssertJUnit.assertEquals((String)("Expected 20 items per page and got " + results.getPageNumItems() + " per page."), (long)20L, (long)results.getPageNumItems());
    }

    @Test
    @AlfrescoTest(jira="MNT-19442")
    public void getDocumentsCmisQueryWithPagination() {
        OperationContextImpl oc = new OperationContextImpl();
        oc.setMaxItemsPerPage(10);
        ItemIterable results = this.contentActions.getCMISSession(this.rmUser.getUsername(), this.rmUser.getPassword()).query(sqlWithName, false, (OperationContext)oc);
        AssertJUnit.assertTrue((String)"Has more items not true. ", (boolean)results.getHasMoreItems());
        AssertJUnit.assertEquals((String)("Total number of items is not 30, got " + results.getTotalNumItems()), (long)30L, (long)results.getTotalNumItems());
        AssertJUnit.assertEquals((String)("Expected 10 items per page and got " + results.getPageNumItems() + " per page."), (long)10L, (long)results.getPageNumItems());
    }

    @AfterClass
    private void clearCmisQueryTests() {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.collaborationSite);
        this.deleteRecordCategory(this.recordFolder.getParentId());
        ((DataUser)this.getDataUser().usingAdmin()).deleteUser(this.rmUser);
        ((DataUser)this.getDataUser().usingAdmin()).deleteUser(this.nonRMUser);
    }
}

