/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.records;

import java.util.Collections;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.model.record.Record;
import org.alfresco.rest.rm.community.model.record.RecordBodyFile;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryChild;
import org.alfresco.rest.rm.community.model.rules.ActionsOnRule;
import org.alfresco.rest.rm.community.model.rules.RuleDefinition;
import org.alfresco.rest.rm.community.requests.gscore.api.FilesAPI;
import org.alfresco.rest.v0.RecordsAPI;
import org.alfresco.rest.v0.RulesAPI;
import org.alfresco.test.AlfrescoTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RejectRecordTests
extends BaseRMRestTest {
    private static final String REJECT_REASON = "Just because";
    private SiteModel publicSite;
    private RecordCategory recordCategory;
    private RecordCategoryChild recordFolder;
    private RecordCategoryChild linkRecordFolder;
    @Autowired
    private RecordsAPI recordsAPI;
    @Autowired
    private RulesAPI rulesAPI;

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.recordCategory = this.createRootCategory(RandomData.getRandomName((String)"recordCategory"));
        this.recordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        this.linkRecordFolder = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"linkRecordFolder"));
    }

    @Test
    @AlfrescoTest(jira="RM-6869")
    public void rejectLinkedRecord() {
        Step.STEP((String)"Create a document in the collaboration site");
        FileModel testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Declare document as record with a location parameter value");
        Record record = ((FilesAPI)this.getRestAPIFactory().getFilesAPI().usingParams(new String[]{String.format("%s=%s", "parentId", this.recordFolder.getId())})).declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Link record to new folder");
        RecordBodyFile linkRecordBody = RecordBodyFile.builder().targetParentId(this.linkRecordFolder.getId()).build();
        this.getRestAPIFactory().getRecordsAPI().fileRecord(linkRecordBody, record.getId());
        Step.STEP((String)"Verify the linked record has been added");
        Assert.assertTrue((boolean)this.isMatchingRecordInRecordFolder(testFile, this.linkRecordFolder), (String)"Linked record not created");
        Step.STEP((String)"Reject record");
        this.recordsAPI.rejectRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), record.getName(), REJECT_REASON);
        Step.STEP((String)"Check record has been rejected");
        Assert.assertFalse((boolean)this.isMatchingRecordInRecordFolder(testFile, this.recordFolder), (String)"Record rejection failure");
        Step.STEP((String)"Verify the linked record has been removed");
        Assert.assertFalse((boolean)this.isMatchingRecordInRecordFolder(testFile, this.linkRecordFolder), (String)"Record link not removed");
    }

    @Test
    @AlfrescoTest(jira="RM-6881")
    public void rejectCompletedRecord() {
        Step.STEP((String)"Create a document in the collaboration site");
        FileModel testFile = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingAdmin().createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create a record folder with a reject rule");
        RecordCategoryChild folderWithRule = this.createFolder(this.recordCategory.getId(), RandomData.getRandomName((String)"recordFolder"));
        RuleDefinition ruleDefinition = RuleDefinition.createNewRule().title("name").description("description").applyToChildren(true).rejectReason(REJECT_REASON).actions(Collections.singletonList(ActionsOnRule.REJECT.getActionValue()));
        this.rulesAPI.createRule(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), "workspace/SpacesStore/" + folderWithRule.getId(), ruleDefinition);
        Step.STEP((String)"Declare document as record to Unfiled Records folder");
        Record record = this.getRestAPIFactory().getFilesAPI().declareAsRecord(testFile.getNodeRefWithoutVersion());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Complete, then file the record to the folder with rule");
        this.completeRecord(record.getId());
        RecordBodyFile recordBodyFile = RecordBodyFile.builder().targetParentId(folderWithRule.getId()).build();
        this.getRestAPIFactory().getRecordsAPI().fileRecord(recordBodyFile, record.getId());
        this.assertStatusCode(HttpStatus.CREATED);
        Step.STEP((String)"Check record hasn't been rejected through rule");
        Assert.assertTrue((boolean)this.isMatchingRecordInRecordFolder(testFile, folderWithRule), (String)"Record rejection succeeded!");
        Step.STEP((String)"Reject record directly through api");
        this.recordsAPI.rejectRecord(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), 500, record.getName(), REJECT_REASON);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() {
        this.deleteRecordCategory(this.recordCategory.getId());
        this.dataSite.deleteSite(this.publicSite);
    }
}

