/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.rmroles;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.rest.rm.community.base.BaseRMRestTest;
import org.alfresco.rest.rm.community.base.TestData;
import org.alfresco.rest.rm.community.model.user.UserRoles;
import org.alfresco.rest.rm.community.util.CommonTestUtils;
import org.alfresco.rest.v0.RMRolesAndActionsAPI;
import org.junit.Assert;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

public class RMRolesTests
extends BaseRMRestTest {
    private static final HashSet<String> CAPABILITIES = Sets.newHashSet((Object[])new String[]{"ViewRecords", "DeclareRecords"});
    @Autowired
    private RMRolesAndActionsAPI rmRolesAndActionsAPI;

    @Test(description="Check the default RM roles exist.")
    public void checkRMRolesExist() {
        Set configuredRoles = this.rmRolesAndActionsAPI.getConfiguredRoles(this.getAdminUser().getUsername(), this.getAdminUser().getPassword());
        TestData.RM_ROLES.forEach(role -> Assert.assertTrue((String)("Could not found role " + role), (boolean)configuredRoles.contains(role)));
    }

    @Test(description="Check the capabilities for the RM user.")
    public void checkCapabilitiesForUser() {
        Set capabilities = this.rmRolesAndActionsAPI.getCapabilitiesForRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), UserRoles.ROLE_RM_USER.roleId);
        Assert.assertEquals((String)"Unexpected capabilities found for RM User.", (Object)capabilities, CAPABILITIES);
    }

    @Test(description="Create a new role.")
    public void createNewRole() {
        String roleName = CommonTestUtils.generateTestPrefix(RMRolesTests.class) + "newName";
        this.rmRolesAndActionsAPI.createRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), roleName, "New Role Label", CAPABILITIES);
        Set actualCapabilities = this.rmRolesAndActionsAPI.getCapabilitiesForRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), roleName);
        Assert.assertEquals((String)"Unexpected capabilities found for RM User.", (Object)actualCapabilities, CAPABILITIES);
    }

    @Test(description="Update a role.")
    public void updateRole() {
        String roleName = CommonTestUtils.generateTestPrefix(RMRolesTests.class) + "Name";
        this.rmRolesAndActionsAPI.createRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), roleName, "Label", Collections.singleton("ViewRecords"));
        this.rmRolesAndActionsAPI.updateRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), roleName, "Updated Label", Collections.singleton("DeclareRecords"));
        Set actualCapabilities = this.rmRolesAndActionsAPI.getCapabilitiesForRole(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), roleName);
        Assert.assertEquals((String)"Unexpected capabilities for edited RM User.", (Object)actualCapabilities, Collections.singleton("DeclareRecords"));
    }
}

