/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rm.community.requests.gscore.api;

import org.alfresco.rest.core.RMRestWrapper;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.rm.community.model.fileplan.FilePlan;
import org.alfresco.rest.rm.community.model.hold.Hold;
import org.alfresco.rest.rm.community.model.hold.HoldCollection;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategory;
import org.alfresco.rest.rm.community.model.recordcategory.RecordCategoryCollection;
import org.alfresco.rest.rm.community.model.role.RoleCollection;
import org.alfresco.rest.rm.community.requests.RMModelRequest;
import org.alfresco.rest.rm.community.util.ParameterCheck;
import org.alfresco.rest.rm.community.util.PojoUtility;
import org.springframework.http.HttpMethod;

public class FilePlanAPI
extends RMModelRequest {
    public FilePlanAPI(RMRestWrapper rmRestWrapper) {
        super(rmRestWrapper);
    }

    public FilePlan getFilePlan(String filePlanId) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getFilePlan(filePlanId, "");
    }

    public FilePlan getFilePlan(String filePlanId, String parameters) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModel(FilePlan.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"/file-plans/{filePlanId}?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public RecordCategoryCollection getRootRecordCategories(String filePlanId) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRootRecordCategories(filePlanId, "");
    }

    public RecordCategoryCollection getRootRecordCategories(String filePlanId, String parameters) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModels(RecordCategoryCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"file-plans/{filePlanId}/categories?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public RecordCategory createRootRecordCategory(RecordCategory recordCategoryModel, String filePlanId) {
        ParameterCheck.mandatoryObject("recordCategoryModel", (Object)recordCategoryModel);
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.createRootRecordCategory(recordCategoryModel, filePlanId, "");
    }

    public RecordCategory createRootRecordCategory(RecordCategory recordCategoryModel, String filePlanId, String parameters) {
        ParameterCheck.mandatoryObject("recordCategoryModel", (Object)recordCategoryModel);
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModel(RecordCategory.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)recordCategoryModel), (String)"file-plans/{filePlanId}/categories?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public FilePlan updateFilePlan(FilePlan filePlanModel, String filePlanId) {
        ParameterCheck.mandatoryObject("filePlanModel", (Object)filePlanModel);
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.updateFilePlan(filePlanModel, filePlanId, "");
    }

    public FilePlan updateFilePlan(FilePlan filePlanModel, String filePlanId, String parameters) {
        ParameterCheck.mandatoryObject("filePlanModel", (Object)filePlanModel);
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModel(FilePlan.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.PUT, (String)PojoUtility.toJson((Object)filePlanModel), (String)"file-plans/{filePlanId}?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public Hold createHold(Hold holdModel, String filePlanId, String parameters) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        ParameterCheck.mandatoryObject("holdModel", (Object)holdModel);
        return this.getRmRestWrapper().processModel(Hold.class, RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)PojoUtility.toJson((Object)holdModel), (String)"file-plans/{filePlanId}/holds", (String[])new String[]{filePlanId, parameters}));
    }

    public Hold createHold(Hold holdModel, String filePlanId) {
        return this.createHold(holdModel, filePlanId, "");
    }

    public HoldCollection getHolds(String filePlanId, String parameters) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModels(HoldCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"file-plans/{filePlanId}/holds?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public HoldCollection getHolds(String filePlanId) {
        return this.getHolds(filePlanId, "");
    }

    public RoleCollection getFilePlanRoles(String filePlanId, String parameters) {
        ParameterCheck.mandatoryString("filePlanId", filePlanId);
        return this.getRmRestWrapper().processModels(RoleCollection.class, RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"file-plans/{filePlanId}/roles?{parameters}", (String[])new String[]{filePlanId, parameters}));
    }

    public RoleCollection getFilePlanRoles(String filePlanId) {
        return this.getFilePlanRoles(filePlanId, "");
    }
}

